/***********************************************************************
 * testwinproc.CPP
 *  
 *    Window for TEST Direct X Demo
 *
 *
 * Toby Opferman Copyright (c) 2002
 *
 ***********************************************************************/
 

                                                                     
#include <windows.h>
#include "testwinproc.h"
#include "testapi.h"
#include "testaudio.h"


extern unsigned int g_ScreenHeight;
extern unsigned int g_ScreenWidth;

 /***********************************************************************
  * Internal APIs
  ***********************************************************************/
 LRESULT CALLBACK TestWinProc_WindowProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
 void TestWinProc_ProcessVirtualKeyPress(HWND hWnd, UINT vKey);

                   
 /***********************************************************************
  * TestWinProc_RegisterClass
  *  
  *    Registers the Test Window Proc Class
  *
  * Parameters
  *     instance Handle
  * 
  * Return Value
  *     TRUE on Success, FALSE on Failure
  *
  ***********************************************************************/
 BOOL WINAPI TestWinProc_RegisterClass(HINSTANCE hInstance)
 {
     WNDCLASSEX WndClassEx = {0};

     WndClassEx.cbSize        = sizeof(WndClassEx);
     WndClassEx.style         = 0;
     WndClassEx.lpfnWndProc   = TestWinProc_WindowProc;
     WndClassEx.cbWndExtra    = 0;
     WndClassEx.hInstance     = hInstance;
     WndClassEx.hIcon         = NULL;
     WndClassEx.hCursor       = NULL;
     WndClassEx.hbrBackground = NULL;
     WndClassEx.lpszMenuName  = NULL;
     WndClassEx.lpszClassName = TEST_CLASS_NAME;
     WndClassEx.hIconSm       = NULL;
     
     return RegisterClassEx(&WndClassEx);
 }



 /***********************************************************************
  * TestWinProc_CreateWindow
  *  
  *    Creates The Test Window
  *
  * Parameters
  *     instance Handle
  * 
  * Return Value
  *     Window Handle on Success, NULL on Failure
  *
  ***********************************************************************/
 HWND WINAPI TestWinProc_CreateWindow(HINSTANCE hInstance)
 {
     HWND hWnd = NULL;

     if(!FindWindow(TEST_CLASS_NAME, NULL))
     {
        if(hWnd = CreateWindowEx(WS_EX_TOPMOST, TEST_CLASS_NAME, "Test Demo", WS_POPUP | WS_VISIBLE, 0,  0, g_ScreenWidth, g_ScreenHeight, HWND_DESKTOP, NULL,  hInstance, NULL))
        {
            ShowWindow(hWnd, SW_HIDE);
            UpdateWindow(hWnd);
        }
     }

     return hWnd;
 }


 /***********************************************************************
  * TestWinProc_MessageLoop
  *  
  *    Handles Window Messages to be dispatched to the Cubix Window
  *
  * Parameters
  *     instance Handle, Window Handle
  * 
  * Return Value
  *     Exit Value
  *
  ***********************************************************************/
 int WINAPI TestWinProc_MessageLoop(HINSTANCE hInstance, HWND hWnd)
 {
     MSG Msg = {0};
     HTESTDEMO hTestDemo;
	 HTESTAUDIO hTestAudio = TestAudio_Init();
     BOOL bMessageLoop = TRUE;

     if(hTestDemo = TestApi_Init(hWnd))
     {
        while(bMessageLoop)
        {
         if(PeekMessage(&Msg, NULL, 0, 0, PM_NOREMOVE))
         {
           if(Msg.message == WM_QUIT)
           {
              bMessageLoop = FALSE;
           }
           else
           {
              PeekMessage(&Msg,NULL, 0, 0, PM_REMOVE);
              TranslateMessage(&Msg);
              DispatchMessage(&Msg);
           }
         }
         else
         {
             TestApi_PerformDemo(hTestDemo);
         }
        }

        TestApi_UnInit(hTestDemo);
     }
     else
     {
         MessageBox(HWND_DESKTOP, "Failed To Initialize Direct X", "FAILURE", MB_OK | MB_ICONEXCLAMATION);
     }

     TestAudio_UnInit(hTestAudio);

     return Msg.wParam;
 }



 /***********************************************************************
  * TestWinProc_WindowProc
  *  
  *    Handles Window Messages Send to the window
  *
  * Parameters
  *     Standard Windows Proc Handler
  * 
  * Return Value
  *     Exit Value
  *
  ***********************************************************************/
 LRESULT CALLBACK TestWinProc_WindowProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)
 {
     LRESULT dwRetValue = 0;

     switch(wMsg)
     {
         case WM_CREATE:
              ShowCursor(FALSE);
			  SetFocus(hWnd);
              break;

         case WM_KEYUP:
              TestWinProc_ProcessVirtualKeyPress(hWnd, wParam);
              break;
            
     	 case WM_CLOSE:
         case WM_DESTROY:
              ShowCursor(TRUE);
              PostQuitMessage(0);
              break;

         default:
              dwRetValue = DefWindowProc(hWnd, wMsg, wParam, lParam);
     }

     return dwRetValue;
 }


 /***********************************************************************
  * TestWinProc_ProcessVirtualKeyPress
  *  
  *    Handles processing virtual keys
  *
  * Parameters
  *     Window Handle, Virtual Key
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
 void TestWinProc_ProcessVirtualKeyPress(HWND hWnd, UINT vKey)
 {
    if(vKey == VK_ESCAPE)
    {
        DestroyWindow(hWnd);
    }

 }



