/***********************************************************************
 * teststar.CPP
 *  
 *    Star Field for Test Direct X Demo
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 

                                                                     
#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <ddraw.h>
#include "testgfx.h"
#include "testapi.h"




 /***********************************************************************
  * Internal Macros
  ***********************************************************************/
#define ANGLE_TO_RADIANS(a) (float)(a*3.14/180.0) 
#define PLASMA_FORMULA_Y(a, b, c) (TestGfx_Cos20(a + b + c)*a + TestGfx_Cos15(a + b + c) + TestGfx_Cos9(b + a*2)*a +  TestGfx_Cos15(a + c) +  TestGfx_Sin25(c)/b)
#define PLASMA_FORMULA_X(a, b, c) (TestGfx_Sin20(a + b + c) + TestGfx_Sin15(a + b + c)*a + TestGfx_Sin8(c + a*2) +  TestGfx_Sin15(a + b) +  TestGfx_Cos25(b)/c)

 /***********************************************************************
  * Globals used by Drawing functions for screen calculation
  ***********************************************************************/
  extern unsigned int g_ScreenWidth;
  extern unsigned int g_ScreenPitch;
  extern unsigned int g_ScreenHeight;


/*

Compiler complains about "++" operations on enums, so use
old fashioned #define and typedef on UINT instead.  Probably
because this filed is named .cpp instead of using a real
file extension, like .c.  But I made this project in C++
just to make it easier using Direct X

typedef enum {

    PS_INC_BLUE = 0,
	PS_DEC_BLUE = 1,
	PS_INC_RED = 2,
	PS_DEC_RED = 3,
	PS_INC_YELLOW = 4,
	PS_DEC_YELLOW = 5,
	PS_NONE = 6

} PALETTE_STAGES;
*/

typedef UINT PALETTE_STAGES;

#define PS_INC_BLUE     0
#define PS_DEC_BLUE     1
#define PS_INC_RED      2
#define PS_DEC_RED      3
#define PS_INC_YELLOW   4
#define PS_DEC_YELLOW   5
#define PS_NONE         6


 /***********************************************************************
  * TestPlasma_GetPalette
  *  
  *    Provide Palette To Calling Function
  *
  * Parameters
  *     Palette Entries
  * 
  * Return Value
  *     0
  *
  ***********************************************************************/
void TestStar_GetPalette(PALETTEENTRY *pPalEntry)
{
    UCHAR Red = 0, 
	      Green = 0, 
		  Blue = 0;
	DWORD Bytes = 0;
	UINT Index = 0;
	PALETTE_STAGES PaletteStage = PS_INC_BLUE;

    for(Index = 0; Index < 256; Index++)
	{

        pPalEntry[Index].peRed = Red;
        pPalEntry[Index].peGreen = Green;
        pPalEntry[Index].peBlue = Blue;
        pPalEntry[Index].peFlags = (BYTE)0;

		if(Index == 43  || Index == 84  || Index == 127 || 
		   Index == 168 || Index == 211 || Index == 252)
		{
			PaletteStage++;
		}


		switch(PaletteStage)
		{
			case PS_INC_BLUE:
                 Blue += 5;
				 break;

			case PS_DEC_BLUE:
                 Blue -= 5;
				 break;

			case PS_INC_RED:
                 Red += 5;
				 break;

		    case PS_DEC_RED:
                 Red -= 5;
				 break;

		    case PS_INC_YELLOW:
                 Red += 5;
				 Green += 5;
				 break;

		    case PS_DEC_YELLOW:
                 Red -= 5;
				 Green -= 5;
				 break;

		    default:
			     Red = 0;
			     Blue = 0;
			     Green = 0;
		}
	}
}





 /***********************************************************************
  * TestPlasma_ShouldSetPalette
  *  
  *    Should Set The Palette
  *
  * Parameters
  *     Palette Entries
  * 
  * Return Value
  *     0
  *
  ***********************************************************************/
BOOL TestPlasma_ShouldSetPalette(void)
{
	static BOOL bShouldSet = TRUE;

    BOOL bReturn = FALSE;

	if(bShouldSet)
	{
		bReturn = TRUE;
		bShouldSet = FALSE;
	}

	return bReturn;
}



 /***********************************************************************
  * TestPlasma_Plasma
  *  
  *    The Plasma
  *
  * Parameters
  *     Video Buffer
  * 
  * Return Value
  *     0
  *
  ***********************************************************************/
BOOL TestPlasma_Plasma(UCHAR *pVideoBuffer, BOOL bShouldFade)
{
	static float DynamicPlasmaValue1 = 1, DynamicPlasmaValue2 = (float).5;
	static float DynamicIncreaseV1 = (float).01, DynamicIncreaseV2 = 1;
	static UINT FadeCounter = 0;
	UINT FadeIndexX1 = 0, FadeIndexX2 = 319;
	BOOL bFaded = FALSE, bShouldDraw = TRUE;
	float IndexY, IndexX;
    POINT2D ScreenPixel;
    
	FadeIndexX1 += FadeCounter*2;
	FadeIndexX2 -= FadeCounter*2;

	for(IndexY = 0; IndexY < g_ScreenHeight; IndexY++)
	{
	  for(IndexX = 0; IndexX < g_ScreenWidth; IndexX++)
	  {
          bShouldDraw = TRUE;

		  if(FadeIndexX1 >= IndexX)
		  {
			  UINT IndexTest = (UINT)IndexX;

			  if(!(IndexTest & 1))
			  {
				  bShouldDraw = FALSE;
			  }
		  }

    	  if(FadeIndexX2 <= IndexX)
		  {
			  UINT IndexTest = (UINT)IndexX;
	
			  if(IndexTest & 1)
			  {
				  bShouldDraw = FALSE;
			  }
		  }
		

          ScreenPixel.X = (UINT)IndexX;
		  ScreenPixel.Y = (UINT)IndexY;

		  if(!bShouldFade || bShouldDraw)
		  {
		     float RadiansX  = ANGLE_TO_RADIANS(IndexX),
				   RadiansY  = ANGLE_TO_RADIANS(IndexY),
				   RadiansD1 = ANGLE_TO_RADIANS(DynamicPlasmaValue1),
				   RadiansD2 = ANGLE_TO_RADIANS(DynamicPlasmaValue2);

			  ScreenPixel.Colour = ((UCHAR)(PLASMA_FORMULA_X(RadiansX, RadiansD1, RadiansD2) + PLASMA_FORMULA_Y(RadiansY, RadiansD1, RadiansD2)));

			  if(ScreenPixel.Colour > 254)
			  {
			     ScreenPixel.Colour = 254;
			  }

			  
		  }
		  else
		  {
			  ScreenPixel.Colour = 0;
		  }
		  
		
