/***********************************************************************
 * testpcx.h
 *  
 *    PCX for Test Direct X Demo
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 
 
 #ifndef __TESTPCX_H__
 #define __TESTPCX_H__
 
 
  typedef struct {
	 
	 UCHAR   ManufactureId;
	 UCHAR   PcxVersion;
	 UCHAR   EncodingType;
	 UCHAR   BitsPerPixel;
	 USHORT  StartXLocation;
	 USHORT  StartYLocation;
	 USHORT  ImageWidth;
	 USHORT  ImageHeight;
	 USHORT  HorziontalDPI;
	 USHORT  VerticleDPI;
     UCHAR   OldEGAPalette[48];
	 UCHAR   Reserved;
	 UCHAR   ColorPlanes;
	 USHORT  BytesPerLine;
	 USHORT  PaletteType;
	 UCHAR   ExtraPadding[58];

 } PCX_FILE_HEADER, *PPCX_FILE_HEADER;

 typedef struct {

	 PCX_FILE_HEADER PcxHeader;
	 PCHAR           ImageData;
	 PALETTEENTRY    ImagePalette[256];

 } TESTPCX, *PTESTPCX;
 
 PTESTPCX TestPcx_LoadImage(CHAR *pszFileName);
 
 
 
 #endif
 
 
