/*******************************************************
 *
 *  TestPcx.cpp
 *
 *     PCX Decoder for Test Demo
 *
 *  Copyright (c) 2003
 *
 *******************************************************/
 
 
 
#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <ddraw.h>
#include "testpcx.h"
#include "testapi.h"

 
 
/*********************************************************
 * Internal Functions
 *********************************************************/
void TestPcx_DecodeRLEFromFile(HANDLE hFile, PTESTPCX pTestPcx);
void TestPcx_DecodePaletteFromFile(HANDLE hFile, PTESTPCX pTestPcx);


 /********************************************************
  *  TestPcx_LoadImage
  *
  *       
  *   
  *
  *
  ********************************************************/
PTESTPCX TestPcx_LoadImage(CHAR *pszFileName)
{
	PTESTPCX pTestPcx = NULL;
	HANDLE hFile;
	DWORD dwBytesRead;

	hFile = CreateFile(pszFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);

	pTestPcx = (PTESTPCX)LocalAlloc(LMEM_ZEROINIT, sizeof(TESTPCX));

	ReadFile(hFile, &pTestPcx->PcxHeader, sizeof(PCX_FILE_HEADER), &dwBytesRead, NULL);

    pTestPcx->PcxHeader.ImageWidth+=2;
	pTestPcx->PcxHeader.ImageHeight++;
    
    pTestPcx->ImageData = (PCHAR)LocalAlloc(LMEM_ZEROINIT, pTestPcx->PcxHeader.ImageWidth * pTestPcx->PcxHeader.ImageHeight);

	TestPcx_DecodeRLEFromFile(hFile, pTestPcx);
	TestPcx_DecodePaletteFromFile(hFile, pTestPcx);

	return pTestPcx;
}


 /********************************************************
  *  TestPcx_DecodeRLEFromFile
  *
  *       
  *   
  *
  *
  ********************************************************/
void TestPcx_DecodeRLEFromFile(HANDLE hFile, PTESTPCX pTestPcx)
{
	UINT Index = 0, ImageSize = pTestPcx->PcxHeader.ImageWidth * pTestPcx->PcxHeader.ImageHeight;
	UCHAR FirstByte, SecondByte;
    DWORD dwBytes;

	SetFilePointer(hFile, 128, NULL, FILE_BEGIN);



	while(Index < ImageSize)
	{
		ReadFile(hFile, &FirstByte, 1, &dwBytes, NULL);

		if(FirstByte >= 192)
		{
			ReadFile(hFile, &SecondByte, 1, &dwBytes, NULL);

		   
			memset(pTestPcx->ImageData + Index, SecondByte, FirstByte - 192);

			Index += (FirstByte - 192);
		}
		else
		{
		  
			pTestPcx->ImageData[Index] = FirstByte;
			Index++;
		}
	}

  


}


 /********************************************************
  *  TestPcx_DecodePaletteFromFile
  *
  *       
  *   
  *
  *
  ********************************************************/
void TestPcx_DecodePaletteFromFile(HANDLE hFile, PTESTPCX pTestPcx)
{
	CHAR Colors[3];
	UINT Index = 0;
	DWORD dwBytesRead;

	SetFilePointer(hFile, -768, NULL, FILE_END);

	while(Index < 256)
	{
		ReadFile(hFile, Colors, 3, &dwBytesRead, NULL);

		pTestPcx->ImagePalette[Index].peRed    = Colors[0];  //>> 2; // Normally PCX files are *4
		pTestPcx->ImagePalette[Index].peGreen  = Colors[1];  //>> 2;//  encoded Palettes. The ones
        pTestPcx->ImagePalette[Index].peBlue   = Colors[2]; // >> 2;//  in this demo are not though.

		Index++;
	}

}



