/***********************************************************************
 * testpal.CPP
 *  
 *    Palette API For TestDemo
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 
 
#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <ddraw.h>
#include "testgfx.h"
#include "testpal.h"





 /***********************************************************************
  * TestPal_FadeToPaletteEntry
  *  
  *    Provide Palette To Calling Function
  *
  * Parameters
  *     Palette Entries
  * 
  * Return Value
  *     0
  *
  ***********************************************************************/
BOOL TestPal_FadeToPaletteEntry(PALETTEENTRY *pPalEntries, PALETTEENTRY PalFade, UINT Speed)
{
    BOOL bFaded = TRUE;
	UINT Index = 0;
    
    for(Index = 0; Index < 256; Index++)
	{

        if(pPalEntries[Index].peRed != PalFade.peRed)
		{
			bFaded = FALSE;

			if(pPalEntries[Index].peRed < PalFade.peRed)
			{
				pPalEntries[Index].peRed += (char)Speed;

				if(pPalEntries[Index].peRed > PalFade.peRed)
				{
                   pPalEntries[Index].peRed = PalFade.peRed;
				}
			}
			else
			{
                pPalEntries[Index].peRed -= (char)Speed;

				if(pPalEntries[Index].peRed < PalFade.peRed)
				{
                   pPalEntries[Index].peRed = PalFade.peRed;
				}

			}

		}

        if(pPalEntries[Index].peGreen != PalFade.peGreen)
		{
			bFaded = FALSE;

			if(pPalEntries[Index].peGreen < PalFade.peGreen)
			{
				pPalEntries[Index].peGreen+= (char)Speed;

				if(pPalEntries[Index].peGreen > PalFade.peGreen)
				{
                   pPalEntries[Index].peGreen = PalFade.peGreen;
				}
			}
			else
			{
                pPalEntries[Index].peGreen-= (char)Speed;

				if(pPalEntries[Index].peGreen < PalFade.peGreen)
				{
                   pPalEntries[Index].peGreen = PalFade.peGreen;
				}
			}
		}

		if(pPalEntries[Index].peBlue != PalFade.peBlue)
		{
			bFaded = FALSE;

			if(pPalEntries[Index].peBlue < PalFade.peBlue)
			{
				pPalEntries[Index].peBlue+= (char)Speed;

				if(pPalEntries[Index].peBlue > PalFade.peBlue)
				{
                   pPalEntries[Index].peBlue = PalFade.peBlue;
				}
			}
			else
			{
                pPalEntries[Index].peBlue-= (char)Speed;

				if(pPalEntries[Index].peBlue < PalFade.peBlue)
				{
                   pPalEntries[Index].peBlue = PalFade.peBlue;
				}
			}
		}
	}

	return bFaded;
}



 /***********************************************************************
  * TestPal_FadeToPalette
  *  
  *    Provide Palette To Calling Function
  *
  * Parameters
  *     Palette Entries
  * 
  * Return Value
  *     0
  *
  ***********************************************************************/
BOOL TestPal_FadeToPalette(PALETTEENTRY *pPalEntries, PALETTEENTRY *PalFadeEntries, UINT Speed)
{
    BOOL bFaded = TRUE;
	UINT Index = 0;
    
    for(Index = 0; Index < 256; Index++)
	{

        if(pPalEntries[Index].peRed != PalFadeEntries[Index].peRed)
		{
			bFaded = FALSE;

			if(pPalEntries[Index].peRed < PalFadeEntries[Index].peRed)
			{
				pPalEntries[Index].peRed+= (char)Speed;

				if(pPalEntries[Index].peRed > PalFadeEntries[Index].peRed)
				{
                   pPalEntries[Index].peRed = PalFadeEntries[Index].peRed;
				}
			}
			else
			{
                pPalEntries[Index].peRed-= (char)Speed;

				if(pPalEntries[Index].peRed < PalFadeEntries[Index].peRed)
				{
                   pPalEntries[Index].peRed = PalFadeEntries[Index].peRed;
				}
			}

		}

        if(pPalEntries[Index].peGreen != PalFadeEntries[Index].peGreen)
		{
			bFaded = FALSE;

			if(pPalEntries[Index].peGreen < PalFadeEntries[Index].peGreen)
			{
				pPalEntries[Index].peGreen+= (char)Speed;

				if(pPalEntries[Index].peGreen > PalFadeEntries[Index].peGreen)
				{
                   pPalEntries[Index].peGreen = PalFadeEntries[Index].peGreen;
				}
			}
			else
			{
                pPalEntries[Index].peGreen-= (char)Speed;

				if(pPalEntries[Index].peGreen < PalFadeEntries[Index].peGreen)
				{
                   pPalEntries[Index].peGreen = PalFadeEntries[Index].peGreen;
				}
			}
		}

		if(pPalEntries[Index].peBlue != PalFadeEntries[Index].peBlue)
		{
			bFaded = FALSE;

			if(pPalEntries[Index].peBlue < PalFadeEntries[Index].peBlue)
			{
				pPalEntries[Index].peBlue+= (char)Speed;

				if(pPalEntries[Index].peBlue > PalFadeEntries[Index].peBlue)
				{
                   pPalEntries[Index].peBlue = PalFadeEntries[Index].peBlue;
				}
			}
			else
			{
                pPalEntries[Index].peBlue-= (char)Speed;

				if(pPalEntries[Index].peBlue < PalFadeEntries[Index].peBlue)
				{
                   pPalEntries[Index].peBlue = PalFadeEntries[Index].peBlue;
				}
			}
		}
	}

	return bFaded;
}




