/***********************************************************************
 * testimage.CPP
 *  
 *    Image Functions for Test Direct X Demo
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 

                                                                     
#include <windows.h>
#include <stdarg.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <ddraw.h>
#include "testgfx.h"
#include "testpcx.h"
#include "testapi.h"


#define ANGLE_TO_RADIANS(a) (float)((a)*3.14/180.0) 

 extern unsigned int g_ScreenWidth;
 extern unsigned int g_ScreenPitch;
 extern unsigned int g_ScreenHeight;

 /***********************************************************************
  * TestImage_PerformImageBounce
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
BOOL TestImage_PerformImageBounce(UCHAR *pVideoBuffer, PTESTPCX pTestPcx)
{
	static USHORT BounceX = g_ScreenWidth/2 - pTestPcx->PcxHeader.ImageWidth/2, 
                  BounceY = g_ScreenHeight/2 - pTestPcx->PcxHeader.ImageHeight/2;
	static USHORT BounceXDirection = 3, BounceYDirection = 3;
	static double StepValue = 1, StepDirection = 1;
	double IndexX, IndexY, IndexYCounter, IndexXCounter;
	double ImageIndex = 0;
    POINT2D ScreenPixel;


	for(IndexY = BounceY, IndexYCounter = 0; ((USHORT)IndexYCounter) < (pTestPcx->PcxHeader.ImageHeight); IndexY++, IndexYCounter += StepValue)
	{
		
		ImageIndex = ((USHORT)IndexYCounter)*pTestPcx->PcxHeader.ImageWidth;
        
		for(IndexXCounter = 0, IndexX = BounceX; ((USHORT)IndexXCounter) < (pTestPcx->PcxHeader.ImageWidth); IndexX ++, ImageIndex += StepValue, IndexXCounter += StepValue)
		{
			 ScreenPixel.X = (UINT)IndexX;
			 ScreenPixel.Y = (UINT)IndexY;
			 ScreenPixel.Colour = pTestPcx->ImageData[((USHORT)ImageIndex)];
			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);
		}
	}


	StepValue += StepDirection;

	if(StepValue < 1)
	{
		StepValue = 1;
		StepDirection = .2;
	}
	else
	{
		if(StepValue > 10)
		{
			StepValue = 10;
			StepDirection = -.2;
		}
	}


	BounceY += BounceYDirection;

	if(BounceY > g_ScreenHeight)
	{
		BounceY = 0;
		BounceYDirection =  ((rand() % 3) + 1);

	}
	else
	{
		if((BounceY + (UINT)(pTestPcx->PcxHeader.ImageHeight/StepValue)) > (USHORT)(g_ScreenHeight - 1))
		{
			BounceY = g_ScreenHeight - (UINT)(pTestPcx->PcxHeader.ImageHeight/StepValue) - 1;

			BounceYDirection = - ((rand() % 3) + 1);
		}
	}

	BounceX += BounceXDirection;

	if(BounceX > g_ScreenWidth)
	{
		
        BounceX = 0;
		BounceXDirection =  ((rand() % 5) + 2);

	}
	else
	{
		if((BounceX + (UINT)(pTestPcx->PcxHeader.ImageWidth/StepValue)) > (USHORT)(g_ScreenWidth - 1))
		{
			BounceX = g_ScreenWidth - (UINT)(pTestPcx->PcxHeader.ImageWidth/StepValue) - 1;
			BounceXDirection =  -((rand() % 5) + 2);
		}
	}

    return TRUE;
}



#define LENS_SIZE 30
#define MAGNIFY_SIZE ((float).25)

 /***********************************************************************
  * TestImage_PerformImageLens
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************
BOOL TestImage_PerformImageLens(UCHAR *pVideoBuffer, PTESTPCX pTestPcx)
{
	static short StartX = 0, StartXIncrement = 1;
    short CenterX = 0, CenterY = 0, StartYIncrement = 2;
	USHORT IndexX, IndexY, IndexXCounter;
	double IndexYCounter, StepValue, StartY;
	USHORT ImageIndex = 0;
    POINT2D ScreenPixel;


	CenterX = g_ScreenWidth/2 - pTestPcx->PcxHeader.ImageWidth/2; 
    CenterY = g_ScreenHeight/2 - pTestPcx->PcxHeader.ImageHeight/2;

	for(IndexY = CenterY, IndexYCounter = 0; IndexYCounter < (pTestPcx->PcxHeader.ImageHeight); IndexY++, IndexYCounter ++)
	{
		for(IndexX = CenterX, IndexXCounter = 0; IndexXCounter < (pTestPcx->PcxHeader.ImageWidth); IndexX++, ImageIndex ++, IndexXCounter ++)
		{
			 ScreenPixel.X = IndexX;
			 ScreenPixel.Y = IndexY;
			 ScreenPixel.Colour = pTestPcx->ImageData[ImageIndex];
			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);
		}
	}

	StartY = 1;
	StartYIncrement = 2;

	for(IndexX = StartX + CenterX; IndexX < StartX + CenterX + LENS_SIZE; IndexX++, StartY += StartYIncrement)
	{
		if(IndexX - (StartX + CenterX) >= LENS_SIZE/2)
		{
           StartYIncrement = -2;
		}

        StepValue = ((double)pTestPcx->PcxHeader.ImageHeight)/((((double)pTestPcx->PcxHeader.ImageHeight + (double)CenterY + (double)StartY)) - ((double)CenterY - (double)StartY)); 

		for(IndexY = CenterY - (USHORT)StartY, IndexYCounter = 0; IndexYCounter < (pTestPcx->PcxHeader.ImageHeight); IndexYCounter += StepValue, IndexY++)
		{
			 ImageIndex = IndexX - CenterX + ((UINT)IndexYCounter*pTestPcx->PcxHeader.ImageWidth);
			 ScreenPixel.X = IndexX;
			 ScreenPixel.Y = IndexY;
			 ScreenPixel.Colour = pTestPcx->ImageData[ImageIndex];

			 if(IndexY > CenterY && IndexY < (CenterY + pTestPcx->PcxHeader.ImageHeight))

			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);

			 
		}
	}

	StartX += StartXIncrement;

	if(StartX >= (pTestPcx->PcxHeader.ImageWidth - LENS_SIZE))
	{
		StartXIncrement = -1;
		StartX = pTestPcx->PcxHeader.ImageWidth - LENS_SIZE;
	}
	else
	{
		if(!StartX)
		{
			StartXIncrement = 1;
		}
	}

    return TRUE;
}
*/

 /***********************************************************************
  * TestImage_PerformImageLens
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
BOOL TestImage_PerformImageLens(UCHAR *pVideoBuffer, PTESTPCX pTestPcx)
{
	static short StartX = 0, StartXIncrement = 1;
	static float CenterLensX = (float)g_ScreenWidth/2, CenterLensY = (float)g_ScreenHeight/2, CenterLensXInc = (float).5, CenterLensYInc = (float).5;
    short CenterX = 0, CenterY = 0, StartYIncrement = 2;
	USHORT IndexX, IndexY, IndexXCounter, IndexYStart;
	float IndexYCounter, IndexImageX, IndexImageY, IndexY_Hidden, IndexX_Hidden;
	USHORT ImageIndex = 0;
    POINT2D ScreenPixel;


	CenterX = g_ScreenWidth/2 - pTestPcx->PcxHeader.ImageWidth/2; 
    CenterY = g_ScreenHeight/2 - pTestPcx->PcxHeader.ImageHeight/2;

    for(IndexY = CenterY, IndexYCounter = 0; IndexYCounter < (pTestPcx->PcxHeader.ImageHeight); IndexY++, IndexYCounter ++)
	{
		for(IndexX = CenterX, IndexXCounter = 0; IndexXCounter < (pTestPcx->PcxHeader.ImageWidth); IndexX++, ImageIndex ++, IndexXCounter ++)
		{
			 ScreenPixel.X = IndexX;
			 ScreenPixel.Y = IndexY;
			 ScreenPixel.Colour = pTestPcx->ImageData[ImageIndex];
			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);
		}
	}


	IndexX = (UINT)CenterLensX - (LENS_SIZE/2);
	IndexX_Hidden = (float)CenterLensX - (LENS_SIZE/16);


	for(; IndexX < (UINT)(CenterLensX + LENS_SIZE/2); IndexX++, IndexX_Hidden += MAGNIFY_SIZE)
	{
  	    IndexYStart = (UINT)sqrt((LENS_SIZE/16)*(LENS_SIZE/16) - ((IndexX_Hidden - CenterLensX)*(IndexX_Hidden - CenterLensX)));

        IndexY_Hidden = (float)(CenterLensY - IndexYStart);

		IndexYStart = (UINT)sqrt((LENS_SIZE/2)*(LENS_SIZE/2) - ((IndexX - CenterLensX)*(IndexX - CenterLensX)));

		IndexY = (UINT)(CenterLensY - IndexYStart);

        IndexImageY = (float)(pTestPcx->PcxHeader.ImageHeight/2 - IndexYStart) + ((IndexY_Hidden - CenterY) - (pTestPcx->PcxHeader.ImageHeight/2 - IndexYStart));

		for(; IndexY < (UINT)(CenterLensY + IndexYStart); IndexY++, IndexImageY += MAGNIFY_SIZE)
		{
			 IndexImageX = (float)sqrt((double)((LENS_SIZE/16)*(LENS_SIZE/16) - (IndexY_Hidden - CenterLensY)*(IndexY_Hidden - CenterLensY)));

			 IndexImageX = (pTestPcx->PcxHeader.ImageWidth/2 - IndexImageX) + (((IndexX - CenterX) - (pTestPcx->PcxHeader.ImageWidth/2 - IndexImageX)));

			 ImageIndex = ((UINT)IndexImageX) + ((UINT)IndexImageY*pTestPcx->PcxHeader.ImageWidth);

			 ScreenPixel.X = IndexX;
			 ScreenPixel.Y = IndexY;
			 ScreenPixel.Colour = pTestPcx->ImageData[ImageIndex];

			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);
		}
	}



	CenterLensY += CenterLensYInc;

	if(CenterLensY + (LENS_SIZE/2) >= CenterY + pTestPcx->PcxHeader.ImageHeight)
	{
		CenterLensY = (float)(CenterY + pTestPcx->PcxHeader.ImageHeight) - (LENS_SIZE/2);
		CenterLensYInc = -(float).5; //  -((rand() % 3) + 1);

	}
	else
	{
		if(CenterLensY - (LENS_SIZE/2) <= CenterY)
		{
			CenterLensY = (float)CenterY + (LENS_SIZE/2);

			CenterLensYInc = (float).5; //((rand() % 3) + 1);
		}
	}

	CenterLensX += CenterLensXInc;

	if(CenterLensX + (LENS_SIZE/2) >= CenterX + pTestPcx->PcxHeader.ImageWidth)
	{
		CenterLensX = (float)(CenterX + pTestPcx->PcxHeader.ImageWidth) - (LENS_SIZE/2);
		CenterLensXInc =  -(float).5;// -((rand() % 3) + 1);

	}
	else
	{
		if(CenterLensX - (LENS_SIZE/2) <= CenterX)
		{
			CenterLensX = (float)CenterX + (LENS_SIZE/2);

			CenterLensXInc =  (float).5;//((rand() % 3) + 1);
		}
	}

	
    return TRUE;
}


 /***********************************************************************
  * TestImage_PerformImageRot
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
BOOL TestImage_PerformImageRot(UCHAR *pVideoBuffer, PTESTPCX pTestPcx)
{
	static float Angle = 1, AngleIncrement = 2;
	float AngleLoop = ANGLE_TO_RADIANS(Angle);
    short CenterX = 0, CenterY = 0, IndexYForImage;
	USHORT IndexYCounter, IndexXCounter;
	short IndexX, IndexY;
	USHORT ImageIndex = 0;
    POINT2D ScreenPixel;


	CenterX = g_ScreenWidth/2; 
    CenterY = g_ScreenHeight/2;

	for(IndexYForImage = pTestPcx->PcxHeader.ImageHeight - 1,IndexY = -pTestPcx->PcxHeader.ImageHeight/2, IndexYCounter = 0; IndexYCounter < (pTestPcx->PcxHeader.ImageHeight); IndexYCounter++, IndexY++, IndexYForImage--)
	{
		ImageIndex = IndexYForImage*pTestPcx->PcxHeader.ImageWidth;

		for(IndexX = -pTestPcx->PcxHeader.ImageWidth/2, IndexXCounter = 0; IndexXCounter < (pTestPcx->PcxHeader.ImageWidth); ImageIndex++, IndexXCounter++, IndexX++)
		{
			 ScreenPixel.X = (UINT) (IndexX*TestGfx_Cos(AngleLoop) + IndexY*TestGfx_Sin(AngleLoop)) + CenterX;
			 ScreenPixel.Y = (UINT) (IndexX*TestGfx_Sin(AngleLoop) - IndexY*TestGfx_Cos(AngleLoop)) + CenterY;

			 ScreenPixel.Colour = pTestPcx->ImageData[ImageIndex];

			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);

			 ScreenPixel.X++;
			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);
             
			 ScreenPixel.X--;
			 ScreenPixel.Y++;
             TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);

		}
	}

    Angle += AngleIncrement;

    return TRUE;
}


typedef struct {
   
	float Radians;
	short CenterX, CenterY, StartWidth, StartHeight;
	USHORT StartY, StartX, Height, Width;

}IMAGEROTATE, *PIMAGEROTATE;


void TestImage_SubRotateImage(UCHAR *pVideoBuffer, PTESTPCX pTestPcx, PIMAGEROTATE pImageRotate);

 /***********************************************************************
  * TestImage_PerformImageRotBreak
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
BOOL TestImage_PerformImageRotBreak(UCHAR *pVideoBuffer, PTESTPCX pTestPcx)
{
    static BOOL bFirstTime = TRUE;
	static float Angle = 0, AngleIncrement = 2;
	static UINT Indexes = 1, StartIndex = 0;
	static IMAGEROTATE ImageRotate[10];
    static UINT Direction = 0;
	UINT Index = 0;

	if(bFirstTime)
	{
		ImageRotate[0].CenterX = g_ScreenWidth/2; 
		ImageRotate[0].CenterY = g_ScreenHeight/2;
		ImageRotate[0].Radians = ANGLE_TO_RADIANS(Angle);
		ImageRotate[0].StartY = pTestPcx->PcxHeader.ImageHeight - 1;
		ImageRotate[0].StartX = 0;
		ImageRotate[0].Height = pTestPcx->PcxHeader.ImageHeight;
		ImageRotate[0].Width  = pTestPcx->PcxHeader.ImageWidth;
		ImageRotate[0].StartHeight = -pTestPcx->PcxHeader.ImageHeight/2;
		ImageRotate[0].StartWidth = -pTestPcx->PcxHeader.ImageWidth/2;

		ImageRotate[1].CenterX = g_ScreenWidth/2 - pTestPcx->PcxHeader.ImageWidth/4 - 10; 
		ImageRotate[1].CenterY = g_ScreenHeight/2;
		ImageRotate[1].Radians = ANGLE_TO_RADIANS(Angle);
		ImageRotate[1].StartY = pTestPcx->PcxHeader.ImageHeight - 1;
		ImageRotate[1].StartX = 0;
		ImageRotate[1].Height = pTestPcx->PcxHeader.ImageHeight;
		ImageRotate[1].Width  = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[1].StartHeight = -pTestPcx->PcxHeader.ImageHeight/2;
		ImageRotate[1].StartWidth = -pTestPcx->PcxHeader.ImageWidth/4;

		ImageRotate[2].CenterX = g_ScreenWidth/2  + pTestPcx->PcxHeader.ImageWidth/4 + 10; 
		ImageRotate[2].CenterY = g_ScreenHeight/2;
		ImageRotate[2].Radians = ANGLE_TO_RADIANS(Angle);
		ImageRotate[2].StartY = pTestPcx->PcxHeader.ImageHeight - 1;
		ImageRotate[2].StartX = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[2].Height = pTestPcx->PcxHeader.ImageHeight;
		ImageRotate[2].Width  = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[2].StartHeight = -pTestPcx->PcxHeader.ImageHeight/2;
		ImageRotate[2].StartWidth = -pTestPcx->PcxHeader.ImageWidth/4;

		ImageRotate[3].CenterX = g_ScreenWidth/2 - pTestPcx->PcxHeader.ImageWidth/4 - 10; 
		ImageRotate[3].CenterY = g_ScreenHeight/2 - pTestPcx->PcxHeader.ImageHeight/4 - 10;
		ImageRotate[3].Radians = ANGLE_TO_RADIANS(Angle);
		ImageRotate[3].StartY = (pTestPcx->PcxHeader.ImageHeight/2);
		ImageRotate[3].StartX = 0;
		ImageRotate[3].Height = pTestPcx->PcxHeader.ImageHeight/2;
		ImageRotate[3].Width  = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[3].StartHeight = -pTestPcx->PcxHeader.ImageHeight/4;
		ImageRotate[3].StartWidth = -pTestPcx->PcxHeader.ImageWidth/4;

		ImageRotate[4].CenterX = g_ScreenWidth/2  + pTestPcx->PcxHeader.ImageWidth/4 + 10; 
		ImageRotate[4].CenterY = g_ScreenHeight/2 - pTestPcx->PcxHeader.ImageHeight/4 - 10;
		ImageRotate[4].Radians = ANGLE_TO_RADIANS(Angle);
		ImageRotate[4].StartY = (pTestPcx->PcxHeader.ImageHeight/2);
		ImageRotate[4].StartX = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[4].Height = pTestPcx->PcxHeader.ImageHeight/2;
		ImageRotate[4].Width  = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[4].StartHeight = -pTestPcx->PcxHeader.ImageHeight/4;
		ImageRotate[4].StartWidth = -pTestPcx->PcxHeader.ImageWidth/4;

		ImageRotate[5].CenterX = g_ScreenWidth/2 - pTestPcx->PcxHeader.ImageWidth/4 - 10; 
		ImageRotate[5].CenterY = g_ScreenHeight/2 + pTestPcx->PcxHeader.ImageHeight/4 + 10;
		ImageRotate[5].Radians = ANGLE_TO_RADIANS(Angle);
		ImageRotate[5].StartY = pTestPcx->PcxHeader.ImageHeight - 1;
		ImageRotate[5].StartX = 0;
		ImageRotate[5].Height = pTestPcx->PcxHeader.ImageHeight/2;
		ImageRotate[5].Width  = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[5].StartHeight = -pTestPcx->PcxHeader.ImageHeight/4;
		ImageRotate[5].StartWidth = -pTestPcx->PcxHeader.ImageWidth/4;

		ImageRotate[6].CenterX = g_ScreenWidth/2  + pTestPcx->PcxHeader.ImageWidth/4 + 10; 
		ImageRotate[6].CenterY = g_ScreenHeight/2 + pTestPcx->PcxHeader.ImageHeight/4 + 10;
		ImageRotate[6].Radians = ANGLE_TO_RADIANS(Angle);
		ImageRotate[6].StartY = pTestPcx->PcxHeader.ImageHeight - 1;
		ImageRotate[6].StartX = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[6].Height = pTestPcx->PcxHeader.ImageHeight/2;
		ImageRotate[6].Width  = pTestPcx->PcxHeader.ImageWidth/2;
		ImageRotate[6].StartHeight = -pTestPcx->PcxHeader.ImageHeight/4;
		ImageRotate[6].StartWidth = -pTestPcx->PcxHeader.ImageWidth/4;
	}


	for(Index = StartIndex; Index < Indexes + StartIndex; Index++)
		TestImage_SubRotateImage(pVideoBuffer, pTestPcx, &ImageRotate[Index]);

    if(Angle < 360)
      Angle += AngleIncrement;
	else
	{
		if(!Direction)
		{
			if(Indexes < 4)
			{
				StartIndex += Indexes;
				Indexes = Indexes*2;
			}
			else
			{
				Direction = 1;
			}
		}
		else
		{
			if(Indexes > 1)
			{
				Indexes = Indexes/2;
				StartIndex -= Indexes;
			}
			else
			{
				Direction = 0;
			}
		}

		Angle = 0;
	}

    return TRUE;

}


void TestImage_SubRotateImage(UCHAR *pVideoBuffer, PTESTPCX pTestPcx, PIMAGEROTATE pImageRotate)
{
	POINT2D ScreenPixel;
    short IndexX, IndexY, IndexYForImage;
    USHORT ImageIndex = 0;
    USHORT IndexYCounter, IndexXCounter;

	for(IndexYForImage = pImageRotate->StartY, IndexY = pImageRotate->StartHeight, IndexYCounter = 0; IndexYCounter < pImageRotate->Height; IndexYCounter++, IndexY++, IndexYForImage--)
	{
		ImageIndex = IndexYForImage*pTestPcx->PcxHeader.ImageWidth + pImageRotate->StartX;

		for(IndexX = pImageRotate->StartWidth, IndexXCounter =  0; IndexXCounter < pImageRotate->Width; ImageIndex++, IndexXCounter++, IndexX++)
		{
			 ScreenPixel.X = (UINT) (IndexX*TestGfx_Cos(pImageRotate->Radians) + IndexY*TestGfx_Sin(pImageRotate->Radians)) + pImageRotate->CenterX;
			 ScreenPixel.Y = (UINT) (IndexX*TestGfx_Sin(pImageRotate->Radians) - IndexY*TestGfx_Cos(pImageRotate->Radians)) + pImageRotate->CenterY;

			 ScreenPixel.Colour = pTestPcx->ImageData[ImageIndex];

			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);

			 ScreenPixel.X++;
			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);
             
			 ScreenPixel.X--;
			 ScreenPixel.Y++;
             TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);

		}
	}

}

 /***********************************************************************
  * TestImage_PerformImageZoom
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
BOOL TestImage_PerformImageZoom(UCHAR *pVideoBuffer, PTESTPCX pTestPcx)
{
	static double StepValue = 20, StepDirection = -.2;
	UINT CenterX, CenterY;
	double IndexX, IndexY, IndexYCounter, IndexXCounter;
	double ImageIndex = 0;
    POINT2D ScreenPixel;
	BOOL bZoomed = FALSE;

  	CenterX = (UINT) (g_ScreenWidth/2 - (pTestPcx->PcxHeader.ImageWidth/2)/StepValue); 
    CenterY = (UINT) (g_ScreenHeight/2 - (pTestPcx->PcxHeader.ImageHeight/2)/StepValue);

	for(IndexY = CenterY, IndexYCounter = 0; ((USHORT)IndexYCounter) < (pTestPcx->PcxHeader.ImageHeight); IndexY++, IndexYCounter += StepValue)
	{
		
		ImageIndex = ((USHORT)IndexYCounter)*pTestPcx->PcxHeader.ImageWidth;
        
		for(IndexXCounter = 0, IndexX = CenterX; ((USHORT)IndexXCounter) < (pTestPcx->PcxHeader.ImageWidth); IndexX ++, ImageIndex += StepValue, IndexXCounter += StepValue)
		{
			 ScreenPixel.X = (UINT)IndexX;
			 ScreenPixel.Y = (UINT)IndexY;
			 ScreenPixel.Colour = pTestPcx->ImageData[((USHORT)ImageIndex)];
			 TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);
		}
	}

    StepValue += StepDirection;

	if(StepValue <= 1)
	{
	   StepValue = 1;
       bZoomed = TRUE;
	}

    return bZoomed;

}

 /***********************************************************************
  * TestImage_PerformImageSinWave
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
BOOL TestImage_PerformImageSinWave(UCHAR *pVideoBuffer, PTESTPCX pTestPcx)
{
	static float StartAngle = 20, StepFrameDirection = 10, StepXDirection = 1;
	UINT CenterX, CenterY;
	UINT IndexX, IndexY, IndexYCounter, IndexXCounter;
	UINT ImageIndex = 0;
	float AngleCounter;
    POINT2D ScreenPixel;

  	CenterX = g_ScreenWidth/2 - pTestPcx->PcxHeader.ImageWidth/2; 
    CenterY = g_ScreenHeight/2 - pTestPcx->PcxHeader.ImageHeight/2;


	AngleCounter = StartAngle;

	for(IndexXCounter = 0, IndexX = CenterX; IndexXCounter < (pTestPcx->PcxHeader.ImageWidth); IndexX ++, AngleCounter += StepXDirection, IndexXCounter++)
	{
        
		IndexY = (UINT)(CenterY + TestGfx_Sin(ANGLE_TO_RADIANS(AngleCounter))*10);
        

		for(IndexYCounter = 0; IndexYCounter < (pTestPcx->PcxHeader.ImageHeight); IndexY++, IndexYCounter ++)
		{
  		   ImageIndex = ((USHORT)IndexYCounter)*pTestPcx->PcxHeader.ImageWidth + IndexXCounter;
		   ScreenPixel.X = (UINT)IndexX;
		   ScreenPixel.Y = (UINT)IndexY;
		   ScreenPixel.Colour = pTestPcx->ImageData[((USHORT)ImageIndex)];

    	   TestGfx_PlotPixel2d(pVideoBuffer, &ScreenPixel);

		   
		}
	}

    StartAngle += StepFrameDirection;


    return TRUE;

}



