/***********************************************************************
 * testgfx.h
 *  
 *    Window for Test Direct X Demo
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/


#ifndef __TESTGFX_H__
#define __TESTGFX_H__


  typedef struct {

      double X;
      double Y;
      double Z;
      char  Colour;

  } POINT3D, *PPOINT3D;


  typedef struct {

      int X;
      int Y;
      UCHAR  Colour;

  } POINT2D, *PPOINT2D;

void TestGfx_DrawLine2d(UCHAR *pVideoBuffer, PPOINT2D pP1, PPOINT2D pP2);
void TestGfx_PlotPixel2d(UCHAR *pVideoBuffer, PPOINT2D pP1);
float TestGfx_Tan(float Radius);
float TestGfx_Cos(float Radius);
float TestGfx_Sin(float Radius);
BOOL TestGfx_CutAway(UCHAR *pVideoBuffer, DWORD *pCounter);
void TestGfx_Project3dTo2d(PPOINT3D pP3D, PPOINT2D pP2D);

float TestGfx_Cos25(float Radius);
float TestGfx_Sin25(float Radius);
float TestGfx_Cos20(float Radius);
float TestGfx_Sin20(float Radius);
float TestGfx_Cos15(float Radius);
float TestGfx_Sin15(float Radius);
float TestGfx_Cos9(float Radius);
float TestGfx_Sin8(float Radius);


#endif



