/***********************************************************************
 * testgfx.CPP
 *  
 *    Graphics API Test Direct X Demo
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 
#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <ddraw.h>
#include "testgfx.h"
#include "testapi.h"

#define ASPECT 1
#define VIEW   256

/*************************************************************************
 *
 * Globals
 *
 *************************************************************************/
 extern unsigned int g_ScreenWidth;
 extern unsigned int g_ScreenPitch;
 extern unsigned int g_ScreenHeight;
 extern unsigned int g_ColorDepth;
 extern PALETTEENTRY g_Palette[256];
 extern DDPIXELFORMAT g_PixelFormat;
 extern unsigned int g_NumberRedBits;
 extern unsigned int g_NumberGreenBits;
 extern unsigned int g_NumberBlueBits;

 DWORD TestGfx_ConvertColor(UCHAR Red, UCHAR Green, UCHAR Blue);

 /***********************************************************************
 * TestGfx_DrawLine2d
 *  
 *    Draws a line in 2d, 
 *
 * Parameters
 *     Video Buffer, Points to draw line.  
 * 
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void TestGfx_DrawLine2d(UCHAR *pVideoBuffer, PPOINT2D pP1, PPOINT2D pP2)
 {
    POINT2D Point;
    int DeltaX, DeltaY, IncX = 1, IncY = 1, Error = 0, Index;

    Point = *pP1;
    
    DeltaX = pP2->X - pP1->X;
    DeltaY = pP2->Y - pP1->Y;

    if(DeltaX < 0)
    {
        DeltaX *= -1;
        IncX  = -1;
    }

    if(DeltaY < 0)
    {
        DeltaY *= -1;
        IncY = -1;
    }


    if(DeltaX > DeltaY)
    {

        for(Index = 0; Index <= DeltaX; Index++)
        {
           
           TestGfx_PlotPixel2d(pVideoBuffer, &Point);

           Error += DeltaY;

           if(DeltaX < Error)
           {
               Error -= DeltaX;
               Point.Y += IncY;
           }

           Point.X += IncX;

        }

    }
    else
    {
        for(Index = 0; Index <= DeltaY; Index++)
        {
           
           TestGfx_PlotPixel2d(pVideoBuffer, &Point);

           Error += DeltaX;

           if(Error > 0)
           {
               Error -= DeltaY;
               Point.X += IncX;
           } 

           Point.Y += IncY;
        }

    }
 }



/***********************************************************************
 * TestGfx_PlotPixel2d
 *  
 *    Plots a pixel in 2d
 *
 *    This function performs clipping to the screen.
 *
 * Parameters
 *     Video buffer, Point to plot
 * 
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void TestGfx_PlotPixel2d(UCHAR *pVideoBuffer, PPOINT2D pP1)
 {

	 switch(g_ColorDepth)
	 {
	     case 8:

		    if(((unsigned int)pP1->Y) < g_ScreenHeight && ((unsigned int)pP1->X) < g_ScreenWidth)
			   pVideoBuffer[pP1->X + pP1->Y*g_ScreenPitch] = pP1->Colour;

			break;

	     case 16:
	     case 24:
	     case 32:

		     if(((unsigned int)pP1->Y) < g_ScreenHeight && ((unsigned int)pP1->X) < g_ScreenWidth)
			 {
				 DWORD dwColor = TestGfx_ConvertColor(g_Palette[pP1->Colour].peRed, g_Palette[pP1->Colour].peGreen, g_Palette[pP1->Colour].peBlue);

				 memcpy(&pVideoBuffer[pP1->X*(g_ColorDepth/8) + pP1->Y*g_ScreenPitch], &dwColor, g_ColorDepth/8);
			 }

			 break;
	 }
 }



/***********************************************************************
 * TestGfx_Sin
 *  
 *    Returns the SIN Wave Value
 *
 *    
 *
 * Parameters
 *     Raduis
 * 
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 float TestGfx_Sin(float Radius)
 {
	 static float Sin[360];
	 static BOOL bSinInit = FALSE;
     UINT uiAngle;

	 if(!bSinInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Sin[uiAngle] = (float)sin(uiAngle*3.14/180.0);
		 }

		 bSinInit = TRUE;
	 }

	 uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;

	 return Sin[uiAngle];
 }

/***********************************************************************
 * TestGfx_Cos
 *  
 *    Returns the COS Wave Value
 *
 *    
 *
 * Parameters
 *     Raduis
 * 
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 float TestGfx_Cos(float Radius)
 {
	 static float Cos[360];
	 static BOOL bCosInit = FALSE;
     UINT uiAngle;

	 if(!bCosInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Cos[uiAngle] = (float)cos(uiAngle*3.14/180.0);
		 }

		 bCosInit = TRUE;
	 }

    uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;


	 return Cos[uiAngle];
 }


 float TestGfx_Cos20(float Radius)
 {
	 static float Cos[360];
	 static BOOL bCosInit = FALSE;
     UINT uiAngle;

	 if(!bCosInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Cos[uiAngle] = (float)cos(uiAngle*3.14/180.0)*20;
		 }

		 bCosInit = TRUE;
	 }

	// uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
	 uiAngle = ((UINT)(Radius)) % 360;

	 return Cos[uiAngle];
 }

 float TestGfx_Cos15(float Radius)
 {
	 static float Cos[360];
	 static BOOL bCosInit = FALSE;
     UINT uiAngle;

	 if(!bCosInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Cos[uiAngle] = (float)cos(uiAngle*3.14/180.0)*15;
		 }

		 bCosInit = TRUE;
	 }

  //   uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
uiAngle = ((UINT)(Radius)) % 360;
	 return Cos[uiAngle];
 }

 float TestGfx_Cos9(float Radius)
 {
	 static float Cos[360];
	 static BOOL bCosInit = FALSE;
     UINT uiAngle;

	 if(!bCosInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Cos[uiAngle] = (float)cos(uiAngle*3.14/180.0)*9;
		 }

		 bCosInit = TRUE;
	 }

   //  uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
	 uiAngle = ((UINT)(Radius)) % 360;

	 return Cos[uiAngle];
 }

  float TestGfx_Sin25(float Radius)
 {
	 static float Sin[360];
	 static BOOL bSinInit = FALSE;
     UINT uiAngle;

	 if(!bSinInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Sin[uiAngle] = (float)sin(uiAngle*3.14/180.0)*25;
		 }

		 bSinInit = TRUE;
	 }

	 //uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
	 uiAngle = ((UINT)(Radius)) % 360;

	 return Sin[uiAngle];
 }


 float TestGfx_Sin20(float Radius)
 {
	 static float Sin[360];
	 static BOOL bSinInit = FALSE;
     UINT uiAngle;

	 if(!bSinInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Sin[uiAngle] = (float)sin(uiAngle*3.14/180.0)*20;
		 }

		 bSinInit = TRUE;
	 }

	// uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
uiAngle = ((UINT)(Radius)) % 360;
	 return Sin[uiAngle];
 }


 float TestGfx_Sin15(float Radius)
 {
	 static float Sin[360];
	 static BOOL bSinInit = FALSE;
     UINT uiAngle;

	 if(!bSinInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Sin[uiAngle] = (float)sin(uiAngle*3.14/180.0)*15;
		 }

		 bSinInit = TRUE;
	 }

	 //uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
	 uiAngle = ((UINT)(Radius)) % 360;

	 return Sin[uiAngle];
 }


 float TestGfx_Sin8(float Radius)
 {
	 static float Sin[360];
	 static BOOL bSinInit = FALSE;
     UINT uiAngle;

	 if(!bSinInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Sin[uiAngle] = (float)sin(uiAngle*3.14/180.0)*8;
		 }

		 bSinInit = TRUE;
	 }

	// uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
	 uiAngle = ((UINT)(Radius)) % 360;

	 return Sin[uiAngle];
 }



 float TestGfx_Cos25(float Radius)
 {
	 static float Cos[360];
	 static BOOL bCosInit = FALSE;
     UINT uiAngle;

	 if(!bCosInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Cos[uiAngle] = (float)cos(uiAngle*3.14/180.0)*25;
		 }

		 bCosInit = TRUE;
	 }

	// uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;
	 uiAngle = ((UINT)(Radius)) % 360;

	 return Cos[uiAngle];
 }



 /***********************************************************************
 * TestGfx_Tan
 *  
 *    Returns the Tan Wave Value
 *
 *    
 *
 * Parameters
 *     Raduis
 * 
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 float TestGfx_Tan(float Radius)
 {
	 static float Tan[360];
	 static BOOL bTanInit = FALSE;
     UINT uiAngle;

	 if(!bTanInit)
	 {
		 for(uiAngle = 0; uiAngle < 360; uiAngle++)
		 {
			 Tan[uiAngle] = (float)tan(uiAngle*3.14/180.0);
		 }

		 bTanInit = TRUE;
	 }

	 uiAngle = ((UINT)(Radius * 180.0 / 3.14)) % 360;

	 return Tan[uiAngle];
 }

/***********************************************************************
 * TestGfx_CutAway
 *  
 *   Cuts Away The Graphics Scren
 *
 *    
 *
 * Parameters
 *     Raduis
 * 
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 BOOL TestGfx_CutAway(UCHAR *pVideoBuffer, DWORD *pCounter)
 {
	 UINT Index = 0, IndexY = 0, IndexX1 = 0, IndexX2 = 319;
	 BOOL bDone = FALSE;

	 while(Index <= *pCounter && Index <= 320/2)
	 {
		 POINT2D Pixel;

		 Pixel.Colour = 0;

		 for(IndexY = 0; IndexY < 200; IndexY++)
		 {
			 Pixel.Y = IndexY;
			 Pixel.X = IndexX1;
             
			 TestGfx_PlotPixel2d(pVideoBuffer, &Pixel);

		     Pixel.X = IndexX2;

			 TestGfx_PlotPixel2d(pVideoBuffer, &Pixel);
		 }

		 IndexX2 -= 2;
		 IndexX1 += 2;
		 Index++;
	 }

	 *pCounter = (*pCounter) + 1;

	 if(*pCounter > 320/2)
		 bDone = TRUE;

	 return bDone;
 }

 /***********************************************************************
 * TestGfx_Project3dTo2d
 *  
 *    Projects a 3D point to 2D.
 *
 *    
 *
 * Parameters
 *     3D Point, 2D Point
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void TestGfx_Project3dTo2d(PPOINT3D pP3D, PPOINT2D pP2D)
 {
   static int HalfScreenHeight = g_ScreenHeight/2;
   static int HalfScreenWidth  = g_ScreenWidth/2;
   
   if(pP3D->Z)
   {
      pP2D->X = (int)(pP3D->X*VIEW/pP3D->Z + HalfScreenWidth);
      pP2D->Y = (int)(HalfScreenHeight - pP3D->Y*ASPECT*VIEW/pP3D->Z);
   }
   else
   {
       pP2D->X = (int)pP3D->X + HalfScreenWidth;
       pP2D->Y = (int)pP3D->Y + HalfScreenHeight;
   }

   pP2D->Colour = pP3D->Colour;
 }

/***********************************************************************
 * TestGfx_ConvertColor
 *  
 *    Projects a 3D point to 2D.
 *
 *    
 *
 * Parameters
 *     3D Point, 2D Point
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 DWORD TestGfx_ConvertColor(UCHAR Red, UCHAR Green, UCHAR Blue)
 {
	 DWORD NewColor = 0;

     if(g_PixelFormat.dwFlags & DDPF_RGB)
	 {

		  if(g_NumberGreenBits < 8)
			  Green = (UCHAR) (((1 << g_NumberGreenBits)/256.0)*(float)Green);

          if(g_NumberBlueBits < 8)
	          Blue = (UCHAR) (((1 << g_NumberBlueBits)/256.0)*(float)Blue);

          if(g_NumberRedBits < 8)
	          Red = (UCHAR) (((1 << g_NumberRedBits)/256.0)*(float)Red);

           NewColor = Blue | (Green << g_NumberBlueBits) | (Red << (g_NumberBlueBits + g_NumberGreenBits));
          
	 }

	 return NewColor;
 }







