/***********************************************************************
 * testaudio.CPP
 *  
 *    Audio for Test Direct X Demo
 *
 *
 *  Supports .WAV files, Very Simplistic Parser
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 
 
 #include <windows.h>
 #include <mmsystem.h>
 #include "testapi.h"
 #include "testaudio.h"
 
 
 
 
 /***********************************************************************
  * Internal Structures
  ***********************************************************************/
typedef struct {
	
	UCHAR IdentifierString[4];
	DWORD dwLength;

} RIFF_CHUNK, *PRIFF_CHUNK;


typedef struct {

    WORD  wFormatTag;         // Format category
	WORD  wChannels;          // Number of channels
	DWORD dwSamplesPerSec;    // Sampling rate
	DWORD dwAvgBytesPerSec;   // For buffer estimation
	WORD  wBlockAlign;        // Data block size
	WORD  wBitsPerSample;

} WAVE_FILE_HEADER, *PWAVE_FILE_HEADER;


typedef struct {

	 WAVEFORMATEX WaveFormatEx;
	 char *pSampleData;
	 UINT Index;
	 UINT Size;

} WAVE_SAMPLE, *PWAVE_SAMPLE;
 
#define SAMPLE_SIZE    (2*2*2000) 

typedef struct {
     
	 HWAVEOUT hWaveOut;
     HANDLE hEvent;
	 HANDLE hThread;
	 WAVE_SAMPLE WaveSample;
	 BOOL bWaveShouldDie;
     WAVEHDR WaveHdr[8];
	 char AudioBuffer[8][SAMPLE_SIZE];

} TESTAUDIO, *PTESTAUDIO;



 /***********************************************************************
  * Internal Functions
  ***********************************************************************/
void CALLBACK TestAudio_WaveOutputCallback(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2);
BOOL TestAudio_OpenWaveSample(CHAR *pFileName, PWAVE_SAMPLE pWaveSample);
void TestAudio_WaveOpen(HWAVEOUT hWaveOut, PTESTAUDIO pTestAudio);
void TestAudio_WaveDone(HWAVEOUT hWaveOut, PTESTAUDIO pTestAudio);
DWORD WINAPI TestAudio_AudioThread(PVOID pDataInput);
void TestAudio_CreateThread(PTESTAUDIO pTestAudio);
void TestAudio_SetupAudio(PTESTAUDIO pTestAudio);
void TestAudio_WaveClose(HWAVEOUT hWaveOut, PTESTAUDIO pTestAudio);
void TestAudio_AudioMixer(PTESTAUDIO pTestAudio, UINT Index);


 /***********************************************************************
  * TestAudio_Init
  *  
  *    Audio!
  *
  * Parameters
  *     Should pass file name in and then allow multiple files be opened.
  *     This would then have the KMIXER do the mixing of the audio streams.
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
 HTESTAUDIO TestAudio_Init(void) 
 {
	 PTESTAUDIO pTestAudio = NULL;
//	 PTESTAUDIO pTestAudio2 = NULL;
 
	 pTestAudio = (PTESTAUDIO)LocalAlloc(LMEM_ZEROINIT, sizeof(TESTAUDIO));
//	 pTestAudio2 = (PTESTAUDIO)LocalAlloc(LMEM_ZEROINIT, sizeof(TESTAUDIO));

	 TestAudio_OpenWaveSample("sample1.wav", &pTestAudio->WaveSample);
//	 TestAudio_OpenWaveSample("sample2.wav", &pTestAudio2->WaveSample);
//	 TestAudio_OpenWaveSample("sample3.wav", &pTestAudio->WaveSample[2]);
//	 TestAudio_OpenWaveSample("sample4.wav", &pTestAudio->WaveSample[3]);

	 waveOutOpen(&pTestAudio->hWaveOut, WAVE_MAPPER, &pTestAudio->WaveSample.WaveFormatEx, (ULONG)TestAudio_WaveOutputCallback, (ULONG)pTestAudio, CALLBACK_FUNCTION);
//	 waveOutOpen(&pTestAudio2->hWaveOut, WAVE_MAPPER, &pTestAudio2->WaveSample.WaveFormatEx, (ULONG)TestAudio_WaveOutputCallback, (ULONG)pTestAudio2, CALLBACK_FUNCTION);

     TestAudio_CreateThread(pTestAudio);
//	 TestAudio_CreateThread(pTestAudio2);

	 return (HTESTAUDIO)pTestAudio;
 }


 /***********************************************************************
  * TestAudio_Init
  *  
  *    Audio!
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
 void TestAudio_UnInit(HTESTAUDIO hTestAudio)
 {
     PTESTAUDIO pTestAudio = (PTESTAUDIO)hTestAudio;

	 pTestAudio->bWaveShouldDie = TRUE;

	 SetEvent(pTestAudio->hEvent);
	 WaitForSingleObject(pTestAudio->hThread, INFINITE);

	 CloseHandle(pTestAudio->hEvent);
	 CloseHandle(pTestAudio->hThread);

	 waveOutClose(pTestAudio->hWaveOut);

	 LocalFree(pTestAudio);

 }
 
 
 /***********************************************************************
  * TestAudio_WaveOutputCallback
  *  
  *    Audio Callback 
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/ 
void CALLBACK TestAudio_WaveOutputCallback(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2)
{
	PTESTAUDIO pTestAudio = (PTESTAUDIO)dwInstance;

	switch(uMsg)
	{
	  case WOM_OPEN:
            TestAudio_WaveOpen(hwo, pTestAudio);
            break;

	   case WOM_DONE:
		    TestAudio_WaveDone(hwo, pTestAudio);
            break;

	   case WOM_CLOSE:
		    TestAudio_WaveClose(hwo, pTestAudio);
		    break;
	}
}



 
 /***********************************************************************
  * TestAudio_WaveOpen
  *  
  *    Audio Callback 
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
void TestAudio_WaveOpen(HWAVEOUT hWaveOut, PTESTAUDIO pTestAudio)
{
  // Do Nothing
}


 /***********************************************************************
  * TestAudio_WaveDone
  *  
  *    Audio Callback 
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
void TestAudio_WaveDone(HWAVEOUT hWaveOut, PTESTAUDIO pTestAudio)
{
    SetEvent(pTestAudio->hEvent);
}


 /***********************************************************************
  * TestAudio_WaveClose
  *  
  *    Audio Callback 
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
void TestAudio_WaveClose(HWAVEOUT hWaveOut, PTESTAUDIO pTestAudio)
{
  // Do Nothing
}



 /***********************************************************************
  * TestAudio_OpenWaveFile
  *  
  *    Audio Callback 
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
BOOL TestAudio_OpenWaveSample(CHAR *pFileName, PWAVE_SAMPLE pWaveSample)
{
	BOOL bSampleLoaded = FALSE;
	HANDLE hFile;
    RIFF_CHUNK RiffChunk = {0};
    DWORD dwBytes;
    WAVE_FILE_HEADER WaveFileHeader;
	DWORD dwIncrementBytes;

	if(hFile = CreateFile(pFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL))
	{
		SetFilePointer(hFile, 12, NULL, FILE_CURRENT);
		char szIdentifier[5] = {0};

		ReadFile(hFile, &RiffChunk, sizeof(RiffChunk), &dwBytes, NULL);
        ReadFile(hFile, &WaveFileHeader, sizeof(WaveFileHeader), &dwBytes, NULL);

		pWaveSample->WaveFormatEx.wFormatTag      = WaveFileHeader.wFormatTag;         
		pWaveSample->WaveFormatEx.nChannels       = WaveFileHeader.wChannels;          
		pWaveSample->WaveFormatEx.nSamplesPerSec  = WaveFileHeader.dwSamplesPerSec;    
		pWaveSample->WaveFormatEx.nAvgBytesPerSec = WaveFileHeader.dwAvgBytesPerSec;   
		pWaveSample->WaveFormatEx.nBlockAlign     = WaveFileHeader.wBlockAlign;  
		pWaveSample->WaveFormatEx.wBitsPerSample  = WaveFileHeader.wBitsPerSample;
		pWaveSample->WaveFormatEx.cbSize          = sizeof(pWaveSample->WaveFormatEx);

        dwIncrementBytes = dwBytes;

        do {
			 SetFilePointer(hFile, RiffChunk.dwLength - dwIncrementBytes, NULL, FILE_CURRENT);

		     ReadFile(hFile, &RiffChunk, sizeof(RiffChunk), &dwBytes, NULL);
             
			 dwIncrementBytes = 0;

			 memcpy(szIdentifier, RiffChunk.IdentifierString, 4); 

		} while(_stricmp(szIdentifier, "data")) ;

		pWaveSample->pSampleData = (char *)LocalAlloc(LMEM_ZEROINIT, RiffChunk.dwLength);

		pWaveSample->Size = RiffChunk.dwLength;

		ReadFile(hFile, pWaveSample->pSampleData, RiffChunk.dwLength, &dwBytes, NULL);

		CloseHandle(hFile);

		bSampleLoaded = TRUE;
	}

	return bSampleLoaded;
}





 /***********************************************************************
  * TestAudio_CreateThread
  *  
  *    Audio Callback 
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
void TestAudio_CreateThread(PTESTAUDIO pTestAudio)
{
    DWORD dwThreadId;

	pTestAudio->hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

	pTestAudio->hThread = CreateThread(NULL, 0, TestAudio_AudioThread, pTestAudio, 0, &dwThreadId);

}

 /***********************************************************************
  * TestAudio_AudioThread
  *  
  *    Audio Thread
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
DWORD WINAPI TestAudio_AudioThread(PVOID pDataInput)
{
	PTESTAUDIO pTestAudio = (PTESTAUDIO)pDataInput;
    DWORD dwReturnValue = 0;
	UINT Index;

	TestAudio_SetupAudio(pTestAudio);

	while(!pTestAudio->bWaveShouldDie)
	{
		WaitForSingleObject(pTestAudio->hEvent, INFINITE);

		for(Index = 0; Index < 8; Index++)
		{
			if(pTestAudio->WaveHdr[Index].dwFlags & WHDR_DONE)
			{
               TestAudio_AudioMixer(pTestAudio, Index);
			   waveOutWrite(pTestAudio->hWaveOut, &pTestAudio->WaveHdr[Index], sizeof(WAVEHDR));
			}
		}
	}

	waveOutReset(pTestAudio->hWaveOut);

	return dwReturnValue;
}




 /***********************************************************************
  * TestAudio_AudioMixer
  *  
  *    Audio Mixer
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
void TestAudio_AudioMixer(PTESTAUDIO pTestAudio, UINT Index)
{
	UINT uiBytesNotUsed = SAMPLE_SIZE;

	pTestAudio->WaveHdr[Index].dwFlags &= ~WHDR_DONE;

    if(pTestAudio->WaveSample.Size - pTestAudio->WaveSample.Index < uiBytesNotUsed)
	{
		memcpy(pTestAudio->AudioBuffer[Index], pTestAudio->WaveSample.pSampleData + pTestAudio->WaveSample.Index, pTestAudio->WaveSample.Size - pTestAudio->WaveSample.Index);

		uiBytesNotUsed -= (pTestAudio->WaveSample.Size - pTestAudio->WaveSample.Index);

		memcpy(pTestAudio->AudioBuffer[Index], pTestAudio->WaveSample.pSampleData, uiBytesNotUsed);

        pTestAudio->WaveSample.Index = uiBytesNotUsed;

		uiBytesNotUsed = 0;
	}
	else
	{
       memcpy(pTestAudio->AudioBuffer[Index], pTestAudio->WaveSample.pSampleData + pTestAudio->WaveSample.Index, uiBytesNotUsed);

	   pTestAudio->WaveSample.Index += SAMPLE_SIZE;
	   uiBytesNotUsed = 0;
	}

    pTestAudio->WaveHdr[Index].lpData = pTestAudio->AudioBuffer[Index];

    pTestAudio->WaveHdr[Index].dwBufferLength = SAMPLE_SIZE - uiBytesNotUsed;
}

 /***********************************************************************
  * TestAudio_SetupAudio
  *  
  *    Audio Thread
  *
  * Parameters
  *     
  * 
  * Return Value
  *     Handle To This Audio Session
  *
  ***********************************************************************/
void TestAudio_SetupAudio(PTESTAUDIO pTestAudio)
{
	UINT Index = 0;

    for(Index = 0; Index < 8; Index++)
	{
	    pTestAudio->WaveHdr[Index].dwBufferLength = SAMPLE_SIZE;
		pTestAudio->WaveHdr[Index].lpData         = pTestAudio->AudioBuffer[Index]; 

		waveOutPrepareHeader(pTestAudio->hWaveOut, &pTestAudio->WaveHdr[Index], sizeof(WAVEHDR));

        TestAudio_AudioMixer(pTestAudio, Index);

		waveOutWrite(pTestAudio->hWaveOut, &pTestAudio->WaveHdr[Index], sizeof(WAVEHDR));

	}
}


