/***********************************************************************
 * testapi.CPP
 *  
 *    API for Test Direct X Demo
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/
 

                                                                     
#include <windows.h>
#include <stdarg.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <ddraw.h>
#include "testgfx.h"
#include "testapi.h"
#include "testaudio.h"
#include "testpal.h"
#include "testpcx.h"
#include "testplasma.h"
#include "testimage.h"


 

 /***********************************************************************
  * Internal Structures
  ***********************************************************************/

typedef enum {

	TESTDEMO_PLASMA,
	TESTDEMO_PLASMA_FADE,
	TESTDEMO_IMAGE_ZOOM,
	TESTDEMO_IMAGE_BOUNCE,
	TESTDEMO_IMAGE_LENS,
	TESTDEMO_IMAGE_ROT,
	TESTDEMO_IMAGE_ROT_BREAK,
	TESTDEMO_IMAGE_SIN_WAVE

} TEST_DEMOS;

  typedef struct {

      HWND hWnd;
      LPDIRECTDRAW lpDirectDraw;
      LPDIRECTDRAWSURFACE lpDirectDrawSurface;
      LPDIRECTDRAWSURFACE lpDirectBackSurface;
	  LPDIRECTDRAWPALETTE lpDirectDrawPalette;
      DDSURFACEDESC ddSurfaceDesc;
	  TEST_DEMOS CurrentDemo;
      PALETTEENTRY CurPalEntry[256];
	  PALETTEENTRY TempPalEntry[256];
	  PTESTPCX pTestPcx;

  } TESTDEMO, *PTESTDEMO;



 /***********************************************************************
  * Globals used by Drawing functions for screen calculation
  ***********************************************************************/
  unsigned int g_ScreenWidth = 320;
  unsigned int g_ScreenPitch;
  unsigned int g_ScreenHeight = 200;
  unsigned int g_ColorDepth = 8 ;
  unsigned int g_NumberRedBits;
  unsigned int g_NumberGreenBits;
  unsigned int g_NumberBlueBits;
  PALETTEENTRY g_Palette[256] = {0};
  DDPIXELFORMAT g_PixelFormat = {0};
  
 /***********************************************************************
  * Internal APIs
  ***********************************************************************/
  void TestApi_Debug(char *pszFormatString, ...);
  void TestApi_ClearVideoBuffer(UCHAR *pVideoBuffer);
  BOOL TestApi_PerformPlasma(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo, BOOL bFadePlasma);
  BOOL TestApi_PerformImageBounce(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo);
  BOOL TestApi_PerformImageLens(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo);
  BOOL TestApi_PerformImageRot(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo);
  BOOL TestApi_PerformImageZoom(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo);
  BOOL TestApi_PerformImageSinWave(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo);
  BOOL TestApi_PerformImageRotBreak(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo);
  BOOL TestApi_SetPalette(PTESTDEMO pTestDemo, PALETTEENTRY *pPaletteEntry);

 /***********************************************************************
  * TestApi_Init
  *  
  *    Initialize Cubix Graphics
  *
  * Parameters
  *     Window  Handle
  * 
  * Return Value
  *     Handle To Cubix
  *
  ***********************************************************************/
HTESTDEMO WINAPI TestApi_Init(HWND hWnd)
{
    PTESTDEMO pTestDemo = NULL;
   
	srand(time(0));

    if(pTestDemo = (PTESTDEMO)LocalAlloc(LMEM_ZEROINIT, sizeof(TESTDEMO)))
    {
       pTestDemo->hWnd = hWnd;
	   pTestDemo->pTestPcx = TestPcx_LoadImage("sample.pcx");
	  // pTestDemo->pTestPcx = (PTESTPCX)LocalAlloc(LMEM_ZEROINIT, sizeof(TESTPCX));

	   //pTestDemo->pTestPcx->PcxHeader.ImageWidth  = 320;
	   //pTestDemo->pTestPcx->PcxHeader.ImageHeight = 200;

	   //pTestDemo->pTestPcx->ImageData = (PCHAR)LocalAlloc(LMEM_ZEROINIT, 320*200);


       if(SUCCEEDED(DirectDrawCreate(NULL, &pTestDemo->lpDirectDraw, NULL)))
       {
           pTestDemo->lpDirectDraw->Initialize(NULL);
           
           pTestDemo->lpDirectDraw->SetCooperativeLevel(hWnd, DDSCL_FULLSCREEN |
                                                           DDSCL_ALLOWMODEX |
                                                           DDSCL_EXCLUSIVE  |
                                                           DDSCL_ALLOWREBOOT);
           pTestDemo->lpDirectDraw->SetDisplayMode(g_ScreenWidth, g_ScreenHeight,  g_ColorDepth);


           pTestDemo->ddSurfaceDesc.dwSize            = sizeof(pTestDemo->ddSurfaceDesc);
           pTestDemo->ddSurfaceDesc.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
           pTestDemo->ddSurfaceDesc.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_COMPLEX | DDSCAPS_FLIP;
           pTestDemo->ddSurfaceDesc.dwBackBufferCount = 1;
           pTestDemo->CurrentDemo = TESTDEMO_IMAGE_ZOOM;
		   

           if(FAILED(pTestDemo->lpDirectDraw->CreateSurface(&pTestDemo->ddSurfaceDesc, &pTestDemo->lpDirectDrawSurface, NULL)))
           {
               TestApi_UnInit((PTESTDEMO)pTestDemo);
               pTestDemo = NULL;
           }
           else
           {
               pTestDemo->ddSurfaceDesc.ddsCaps.dwCaps    = DDSCAPS_BACKBUFFER;
               
               if(FAILED(pTestDemo->lpDirectDrawSurface->GetAttachedSurface(&pTestDemo->ddSurfaceDesc.ddsCaps, &pTestDemo->lpDirectBackSurface)))
               {
                   TestApi_UnInit((PTESTDEMO)pTestDemo);
                   pTestDemo = NULL;
               }
           }

       }
       else
       {
           TestApi_UnInit((PTESTDEMO)pTestDemo);
           pTestDemo = NULL;
       }
    }

    return (PTESTDEMO)pTestDemo;
}


 /***********************************************************************
  * TestApi_UnInit
  *  
  *    UnInitialize Test Graphics
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
void WINAPI TestApi_UnInit(HTESTDEMO hTestDemo)
{
    PTESTDEMO pTestDemo = (PTESTDEMO)hTestDemo;

    if(pTestDemo)
    {

        if(pTestDemo->lpDirectDrawSurface)
        {
            pTestDemo->lpDirectDrawSurface->Release();
            pTestDemo->lpDirectDrawSurface = NULL;
        }

        if(pTestDemo->lpDirectDraw)
        {
            pTestDemo->lpDirectDraw->Release();
            pTestDemo->lpDirectDraw = NULL;
        }


        LocalFree(pTestDemo);

        pTestDemo = NULL;
    }
}


 /***********************************************************************
  * TestApi_PerformPlasma
  *  
  *   Perform Plasma Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
BOOL TestApi_PerformPlasma(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo, BOOL bFadePlasma)
{
    static BOOL bFaded = FALSE;
	static DWORD dwCountDown = 300;
	BOOL bDone =FALSE;

	if(TestPlasma_ShouldSetPalette())
	{
	   TestPlasma_GetPalette(pTestDemo->TempPalEntry);

	}

	if(!bFaded)
	{

		bFaded = TestPal_FadeToPalette(pTestDemo->CurPalEntry, pTestDemo->TempPalEntry, 3);

	    TestApi_SetPalette(pTestDemo, pTestDemo->CurPalEntry);
	}
	else
	{
		dwCountDown--;
	}

	bDone = TestPlasma_Plasma(pVideoBuffer, bFadePlasma);

	if(!bFadePlasma && dwCountDown == 0)
	{
		bDone = TRUE;
	}

    return bDone;
}


 /***********************************************************************
  * TestApi_PerformDemo
  *  
  *    Display The Demo
  *
  * Parameters
  *     Handle to Test
  * 
  * Return Value
  *     Nothing
  *
  ***********************************************************************/
void WINAPI TestApi_PerformDemo(HTESTDEMO hTestDemo)
{
   PTESTDEMO pTestDemo = (PTESTDEMO)hTestDemo;
   UCHAR  *pVideoBuffer;


   pTestDemo->ddSurfaceDesc.dwSize = sizeof(pTestDemo->ddSurfaceDesc);

   

   if(SUCCEEDED(pTestDemo->lpDirectBackSurface->Lock(NULL, &pTestDemo->ddSurfaceDesc, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL)))
   {
	   static BOOL bFirstTime = TRUE;

	   if(pTestDemo->ddSurfaceDesc.dwFlags & DDSD_PITCH)
          g_ScreenPitch  = pTestDemo->ddSurfaceDesc.lPitch;

	   if(bFirstTime)
	   {
		bFirstTime = FALSE;


		if(pTestDemo->ddSurfaceDesc.dwFlags & DDSD_HEIGHT)
           g_ScreenHeight = pTestDemo->ddSurfaceDesc.dwHeight;

		if(pTestDemo->ddSurfaceDesc.dwFlags & DDSD_WIDTH)
           g_ScreenWidth  = pTestDemo->ddSurfaceDesc.dwWidth;

		if(pTestDemo->ddSurfaceDesc.dwFlags & DDSD_PIXELFORMAT)
		{
           g_PixelFormat = pTestDemo->ddSurfaceDesc.ddpfPixelFormat;
		   

		   if(g_PixelFormat.dwFlags & DDPF_RGB && g_ColorDepth > 8)
		   {
			     UINT dwFormatWalker;

                 g_ColorDepth = g_PixelFormat.dwRGBBitCount;
			     g_NumberBlueBits  = 0;
			     g_NumberRedBits   = 0;
                 g_NumberGreenBits = 0;
				 
				 dwFormatWalker = g_PixelFormat.dwBBitMask;

			     while(dwFormatWalker)
				 {
					 g_NumberBlueBits++;
					 dwFormatWalker >>= 1;
				 }

				 dwFormatWalker = g_PixelFormat.dwRBitMask;

			     while(!(dwFormatWalker & 1))
				 {
					 dwFormatWalker >>= 1;
				 }

			     while(dwFormatWalker)
				 {
					 g_NumberRedBits++;
					 dwFormatWalker >>= 1;
				 }

				 dwFormatWalker = g_PixelFormat.dwGBitMask;

			     while(!(dwFormatWalker & 1))
				 {
					 dwFormatWalker >>= 1;
				 }

			     while(dwFormatWalker)
				 {
					 g_NumberGreenBits++;
					 dwFormatWalker >>= 1;
				 }

		   }
		}

		// TestPlasma_GetPalette(pTestDemo->pTestPcx->ImagePalette);

	   }

      //  TestPlasma_PlasmaToImage(pTestDemo->pTestPcx, FALSE);

        pVideoBuffer = (UCHAR *)pTestDemo->ddSurfaceDesc.lpSurface;
        
	    TestApi_ClearVideoBuffer(pVideoBuffer);

		switch(pTestDemo->CurrentDemo)
		{
			case TESTDEMO_PLASMA:
			   	 if(TestApi_PerformPlasma(pVideoBuffer, pTestDemo, FALSE))
				 {
					 pTestDemo->CurrentDemo = TESTDEMO_PLASMA_FADE;
				 }
				 break;
		    
    		case TESTDEMO_PLASMA_FADE:
		    	 if(TestApi_PerformPlasma(pVideoBuffer, pTestDemo, TRUE))
				 {
                     pTestDemo->CurrentDemo = TESTDEMO_IMAGE_ZOOM;
				 }
			     break;

   		    case TESTDEMO_IMAGE_SIN_WAVE:
                 if(TestApi_PerformImageSinWave(pVideoBuffer, pTestDemo))
				 {
                   pTestDemo->CurrentDemo =  TESTDEMO_IMAGE_LENS;
				 }
				 break;

			case TESTDEMO_IMAGE_ZOOM:
                 if(TestApi_PerformImageZoom(pVideoBuffer, pTestDemo))
				 {
                    pTestDemo->CurrentDemo = TESTDEMO_IMAGE_SIN_WAVE;
				 }
				 break;

			case TESTDEMO_IMAGE_BOUNCE:
                 TestApi_PerformImageBounce(pVideoBuffer, pTestDemo);
				 break;

		    case TESTDEMO_IMAGE_LENS:
   	             if(TestApi_PerformImageLens(pVideoBuffer, pTestDemo))
				 {
					 pTestDemo->CurrentDemo = TESTDEMO_IMAGE_ROT_BREAK;
				 }
				 break;

		    case TESTDEMO_IMAGE_ROT:
  				 TestApi_PerformImageRot(pVideoBuffer, pTestDemo);
				 break;

		    case TESTDEMO_IMAGE_ROT_BREAK:
	             if(TestApi_PerformImageRotBreak(pVideoBuffer, pTestDemo))
				 {
                    pTestDemo->CurrentDemo = TESTDEMO_IMAGE_BOUNCE;
				 }
			     break;

		}

        
        pTestDemo->lpDirectBackSurface->Unlock(NULL);

        while(FAILED(pTestDemo->lpDirectDrawSurface->Flip(NULL, DDFLIP_WAIT))) ;
   }

}


/***********************************************************************
 * TestApi_PerformImageBounce
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
BOOL TestApi_PerformImageBounce(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo)
{

	TestApi_SetPalette(pTestDemo, pTestDemo->pTestPcx->ImagePalette);

	return TestImage_PerformImageBounce(pVideoBuffer, pTestDemo->pTestPcx);
}


/***********************************************************************
 * TestApi_PerformImageLens
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
BOOL TestApi_PerformImageLens(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo)
{
    static DWORD dwCount = 1000;
	TestApi_SetPalette(pTestDemo, pTestDemo->pTestPcx->ImagePalette);
	BOOL bDone = FALSE;

	dwCount--;
	TestImage_PerformImageLens(pVideoBuffer, pTestDemo->pTestPcx);

	if(!dwCount)
		bDone = TRUE;

	return bDone;
}



/***********************************************************************
 * TestApi_PerformImageRot
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
BOOL TestApi_PerformImageRot(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo)
{

	TestApi_SetPalette(pTestDemo, pTestDemo->pTestPcx->ImagePalette);

    return TestImage_PerformImageRot(pVideoBuffer, pTestDemo->pTestPcx);
}


/***********************************************************************
 * TestApi_PerformImageRot3D
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
BOOL TestApi_PerformImageRotBreak(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo)
{
	static DWORD dwCount = 360 + 360 + 360;
	BOOL bDone = FALSE;

	dwCount--;
	TestApi_SetPalette(pTestDemo, pTestDemo->pTestPcx->ImagePalette);

	if(!dwCount)
       bDone = TRUE;

	TestImage_PerformImageRotBreak(pVideoBuffer, pTestDemo->pTestPcx);

    return bDone;
}

/***********************************************************************
 * TestApi_PerformImageRot
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
BOOL TestApi_PerformImageZoom(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo)
{


	TestApi_SetPalette(pTestDemo, pTestDemo->pTestPcx->ImagePalette);

    return TestImage_PerformImageZoom(pVideoBuffer, pTestDemo->pTestPcx);
}

/***********************************************************************
 * TestApi_PerformImageSinWave
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
BOOL TestApi_PerformImageSinWave(UCHAR *pVideoBuffer, PTESTDEMO pTestDemo)
{
	static DWORD dwCount = 200;
	BOOL bDone = FALSE;

	dwCount--;

	TestApi_SetPalette(pTestDemo, pTestDemo->pTestPcx->ImagePalette);

    TestImage_PerformImageSinWave(pVideoBuffer, pTestDemo->pTestPcx);

	if(!dwCount)
		bDone = TRUE;


	 return bDone;

}

/***********************************************************************
 * TestApi_SetPalette
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/

BOOL TestApi_SetPalette(PTESTDEMO pTestDemo, PALETTEENTRY *pPaletteEntry)
{
    if(g_ColorDepth <= 8)
	{
		if(!(FAILED(pTestDemo->lpDirectDraw->CreatePalette(DDPCAPS_8BIT | DDPCAPS_ALLOW256, pPaletteEntry, &pTestDemo->lpDirectDrawPalette, NULL))))
		{
			pTestDemo->lpDirectDrawSurface->SetPalette(pTestDemo->lpDirectDrawPalette);
		}
	}
	else
	{
		DWORD Index;

		for(Index = 0; Index < 256; Index++)
		{
			g_Palette[Index].peBlue = pPaletteEntry[Index].peBlue;
			g_Palette[Index].peRed = pPaletteEntry[Index].peRed;
			g_Palette[Index].peGreen = pPaletteEntry[Index].peGreen;
		}
	}

	return TRUE;
}

/***********************************************************************
 * TestApi_ClearVideoBuffer
 *  
 *    Clear Video Buffer
 *
 * Parameters
 *     Video Buffer
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void TestApi_ClearVideoBuffer(UCHAR *pVideoBuffer)
{
   UINT Multiple = g_ColorDepth/8;

   for(unsigned int y = 0; y < g_ScreenHeight; y++)
     memset(&pVideoBuffer[y*g_ScreenPitch], 0, g_ScreenWidth*Multiple);
}

/***********************************************************************
 * TestApi_Debug
 *  
 *    Debug Shit
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void TestApi_Debug(char *pszFormatString, ...)
 {
     char DebugString[256];
     va_list vl;

     va_start(vl, pszFormatString);
     vsprintf(DebugString, pszFormatString, vl);
     va_end(vl);

     OutputDebugString(DebugString);
 }


