--------------------------------------------
-- POKER.ADA
--
--         D R A W        P O K E R
--
--
--               For VAX/VMS
--            Copyright (C)1996
--
--  Coded Novemeber 1996
--
--     Modules needed for compile
--         * POKER.ADA  - This module.  It is the Main module that
--                        drives the program.
--
--         * DATA_PKG.PKG -  The Data Structures package.
--
--         * TERMINAL_PKG.PKG - This Package Contains a Few
--                              Miscellaneous functions to interact
--                              with VT200 Emulation & VAX/VMS Operating
--                              System.
--
--         * INIT_PKG.PKG - The Initialization Package.  Displays a
--                          Title screen and Creates a deck.
--
--         * MENU_PKG.PKG - The Menu Package displays a menu to the user
--                          and dispatches the user's choice.
--
--         * GAME_PKG.PKG - This package contains the Game routines.
--                          All game play and modules are defined here.
--
--         * GAM2_PKG.PKG - This is the sub package for GAME_PKG.  The
--                          orignal started to exceed it's size.
--
--     **************AMENDMENTS****************
--         * CARD_PKG.PKG - An Amendment To The Orignal Specification
--                          Since I did not know how to play poker at
--                          the time, this was overlooked.  This Package
--                          contains Functions to Determine the player's
--                          hand.
--
--         * RAN_PKG.PKG  - An Amendment To The Orignal Specification
--			    This has random number routines.
--
--
--  How To Compile:
--
--          (Must Be Compiled In Order)
--    BeforeHand, ACS SET LIBRARY [Your Ada Lib Dir]
--
--             -COMPILE-
--         *     ADA DATA_PKG.PKG
--         *     ADA TERMINAL_PKG.PKG
--         *     ADA INIT_PKG.PKG
--         *     ADA RAN_PKG.PKG
--         *     ADA CARD_PKG.PKG
--         *     ADA GAM2_PKG.PKG
--         *     ADA GAME_PKG.PKG
--         *     ADA MENU_PKG.PKG
--         *     ADA POKER.ADA
--
--             -LINK-
--         *     ACS LINK POKER
--
--  Toby Opferman
--------------------------------------------

-- Ada Packages
With Text_IO;
Use Text_IO;

-- Poker Packages
  -- Package Contains Data Structures/Types
With Data_PKG;
Use Data_PKG;

  -- Package Contains Initial Procedures
With Init_PKG;
Use Init_PKG;

  -- Package Handles the Menu
With Menu_PKG;
Use Menu_PKG;


-- Main Module 
Procedure Poker Is

-- Data
 Human : Player;
 Computer : Player3;
 Deck : DeckAccess;

Begin -- Start Of Execution

 -- Initiailize Variables & Display Title Screen
 Deck := Init;

 -- Make Sure DECK has Been Allocated
 IF Deck = NULL Then

   -- Deck Has NOT Been Correctly Allocated
   PUT("OUT OF MEMORY");
   NEW_LINE;

 ELSE

  -- Display Menu
  Menu(Human, Computer, Deck);

  -- Clean Up Access
  CleanUp(Deck);
  
  -- Display End Screen
  EndMesg;

 End If;
 
End Poker;

-- End POKER.ADA












