;*********************************************************
; Plasma
;  Written in Assembly using Direct Draw for WIN32
;
;  Toby Opferman
;    Copyright (c) 2003 All Rights Reserved
;
;*********************************************************
;       D I S C L A I M E R  AND  L I S E N C E    
;   
; I license out this code for educational use only.
; There are no warranties implied.  Use at your own RISK.  
; I am NOT responsible for any catastrophic results which 
; may occur from using or replicating of this code in any
; shape or form.
;    
; Free to use this code for reference as an educational  
; tool only.  If you use any of the subroutines give credit
; where credit is due.  
;
; You may not use any of this source for commerical use
; without notifying the author for permission.
;
;*********************************************************

.486p
.MODEL FLAT, STDCALL
option casemap :none

include windows.inc
include ddraw.inc
include masm32.inc
include user32.inc
include kernel32.inc
include gdi32.inc


L                 EQU <DWORD>
SCREEN_WIDTH      EQU <640>
SCREEN_HEIGHT     EQU <480>
SCREEN_COLORDEPTH EQU <16>  ; We are assuming 5 - 6 - 5 bit layout!!!!
                            ; This demo is only supported on cards that use this layout.
                            
;*********************************************************
; Extra Direct Draw Defines, Not In ddraw.inc
;*********************************************************
LPDIRECTDRAW        EQU <DWORD>
LPDIRECTDRAWSURFACE EQU <DWORD>
DDSCAPS             EQU <DWORD>

;
; Offsets Into Direct Draw Virtual Table
;
DDRAWDD_QueryInterface             EQU <00h>
DDRAWDD_AddRef                     EQU <04h>
DDRAWDD_Release                    EQU <08h>
DDRAWDD_Compact                    EQU <0Ch>
DDRAWDD_CreateClipper              EQU <10h>
DDRAWDD_CreatePalette              EQU <14h>
DDRAWDD_CreateSurface              EQU <18h>
DDRAWDD_DuplicateSurface           EQU <1Ch>
DDRAWDD_EnumDisplayModes           EQU <20h>
DDRAWDD_EnumSurfaces               EQU <24h>
DDRAWDD_FlipToGDISurface           EQU <28h>
DDRAWDD_GetCaps                    EQU <2Ch>
DDRAWDD_GetDisplayMode             EQU <30h>
DDRAWDD_GetFourCCCodes             EQU <34h>
DDRAWDD_GetGDISurface              EQU <38h>
DDRAWDD_GetMonitorFrequency        EQU <3Ch>
DDRAWDD_GetScanLine                EQU <40h>
DDRAWDD_GetVerticalBlankStatus     EQU <44h>
DDRAWDD_Initialize                 EQU <48h>
DDRAWDD_RestoreDisplayMode         EQU <4Ch>
DDRAWDD_SetCooperativeLevel        EQU <50h>
DDRAWDD_SetDisplayMode             EQU <54h>
DDRAWDD_WaitForVerticalBlank       EQU <58h>

;
; Offsets Into Direct Draw Surface Virtual Table
;
DDRAWDD_Surface_QueryInterface          EQU <00h>
DDRAWDD_Surface_AddRef                  EQU <04h>
DDRAWDD_Surface_Release                 EQU <08h>
DDRAWDD_Surface_AddAttachedSurface      EQU <0Ch>
DDRAWDD_Surface_AddOverlayDirtyRect     EQU <10h>
DDRAWDD_Surface_Blt                     EQU <14h>
DDRAWDD_Surface_BltBatch                EQU <18h>
DDRAWDD_Surface_BltFast                 EQU <1Ch>
DDRAWDD_Surface_DeleteAttachedSurfaces  EQU <20h>
DDRAWDD_Surface_EnumAttachedSurfaces    EQU <24h>
DDRAWDD_Surface_EnumOverlayZOrders      EQU <28h>
DDRAWDD_Surface_Flip                    EQU <2Ch>
DDRAWDD_Surface_GetAttachedSurface      EQU <30h>
DDRAWDD_Surface_GetBltStatus            EQU <34h>
DDRAWDD_Surface_GetCaps                 EQU <38h>
DDRAWDD_Surface_GetClipper              EQU <3Ch>
DDRAWDD_Surface_GetColorKey             EQU <40h>
DDRAWDD_Surface_GetDC                   EQU <44h>
DDRAWDD_Surface_GetFlipStatus           EQU <48h>
DDRAWDD_Surface_GetOverlayPosition      EQU <4Ch>
DDRAWDD_Surface_GetPalette              EQU <50h>
DDRAWDD_Surface_GetPixelFormat          EQU <54h>
DDRAWDD_Surface_GetSurfaceDesc          EQU <58h>
DDRAWDD_Surface_Initialize              EQU <5Ch>
DDRAWDD_Surface_IsLost                  EQU <60h>
DDRAWDD_Surface_Lock                    EQU <64h>
DDRAWDD_Surface_ReleaseDC               EQU <68h>
DDRAWDD_Surface_Restore                 EQU <6Ch>
DDRAWDD_Surface_SetClipper              EQU <70h>
DDRAWDD_Surface_SetColorKey             EQU <74h>
DDRAWDD_Surface_SetOverlayPosition      EQU <7Ch>
DDRAWDD_Surface_Unlock                  EQU <80h>

; Constants
DDSCL_FULLSCREEN        EQU <1>
DDSD_CAPS               EQU <1>
DDSCAPS_PRIMARYSURFACE  EQU <200h>
DDSCAPS_BACKBUFFER      EQU <4>
DDSCL_ALLOWMODEX        EQU <40h>
DDSD_BACKBUFFERCOUNT    EQU <20h>
DDSCL_EXCLUSIVE         EQU <10h>
DDSCAPS_FLIP            EQU <10h>
DDSCAPS_COMPLEX         EQU <8>
DDSCL_ALLOWREBOOT       EQU <2>
DDLOCK_SURFACEMEMORYPTR EQU <0>
DDFLIP_WAIT             EQU <1>
DDLOCK_WAIT             EQU <1>

; Error Code Constants
DD_OK                   EQU <0>


; Structures
DDCOLORKEY STRUCT
    dwColorSpaceLowValue   DWORD ?
    dwColorSpaceHighValue  DWORD ?
DDCOLORKEY ENDS
 
DDPIXELFORMAT STRUCT
    dwSize               DWORD ?
    dwFlags              DWORD ?
    dwFourCC             DWORD ?
    dwRGBBitCount        DWORD ?
    dwRBitMask           DWORD ?
    dwGBitMask           DWORD ?
    dwBBitMask           DWORD ?
    dwRGBAlphaBitMask    DWORD ?
DDPIXELFORMAT ENDS

 
DDSURFACEDESC STRUCT  
    dwSize              DWORD ?
    dwFlags             DWORD ?
    dwHeight            DWORD ?
    dwWidth             DWORD ?
    lPitch              DWORD ?
    dwBackBufferCount   DWORD ?
    
    RefreshRate         DWORD ?
    
    dwAlphaBitDepth     DWORD ?
    dwReserved          DWORD ?
    lpSurface           DWORD ?
    
    ddckCKDestOverlay   DDCOLORKEY <>
    ddckCKDestBlt       DDCOLORKEY <>
    ddckCKSrcOverlay    DDCOLORKEY <>
    ddckCKSrcBlt        DDCOLORKEY <>
    
    ddpfPixelFormat     DDPIXELFORMAT <>
    ddsCaps             DDSCAPS ?
DDSURFACEDESC ENDS



;*********************************************************
; Global Library Data And Structures
;*********************************************************
.DATA?

; UnInitialized Variables
 WndClassEx            WNDCLASSEX          <?>
 hInstance             DWORD                ?
 Msg                   MSG                 <?>
 ghWnd                 DWORD                ?
 lpDirectDraw          LPDIRECTDRAW         ?
 lpDirectDrawSurface   LPDIRECTDRAWSURFACE  ?
 lpDirectBackSurface   LPDIRECTDRAWSURFACE  ?
 DSurfaceDesc          DDSURFACEDESC       <?>
 DSurfaceCaps          DDSCAPS              ?
 pVideoBuffer          DWORD ?
 lPitch                DWORD ?
 lPitch2               DWORD ?
 bPlasmaOk             DWORD ?
 Palette               WORD  256     DUP(?)
 Temp1                 DWORD ?
 Temp2                 DWORD ?
 Temp3                 DWORD ?
 Temp5                 DWORD ?
 IndexX                QWORD ?
 IndexY                QWORD ?
 IndexX1               DWORD ?
 IndexY1               DWORD ?
 DV1                   QWORD ?
 DV2                   QWORD ?
 SinTable              QWORD 360 DUP(?)
 CosTable              QWORD 360 DUP(?)

 pszWindowClass        db 4 DUP(?)
 
 PlasmaDynamicV1       QWORD ?
 PlasmaDynamicV2       QWORD ?
 PlasmaDynamicInc1     QWORD ?
 PlasmaDynamicInc2     QWORD ?
 Radians               QWORD ?

 
;.DATA 

; Initialized Variables
 
; pszWindowClass     db "TestDemo", 0
; PlasmaDynamicV1    QWORD 10.0
; PlasmaDynamicV2    QWORD 50.0
; PlasmaDynamicInc1  QWORD 5.5  ;.5
; PlasmaDynamicInc2  QWORD 10.0 ; 3
; Radians            QWORD 0.017453292519943295769236907684886
 
;*********************************************************
; Application Code
;*********************************************************
.CODE

Plasma_EntryPoint:
  
  CALL Plasma_InitVars
  
  PUSH 0
  CALL GetModuleHandle
  MOV  [hInstance], EAX
  
  CALL Plasma_RegisterWindow
  CALL Plasma_CreateWindow
  MOV [ghWnd], EAX
  PUSH EAX

  PUSH SW_SHOWNORMAL
  PUSH EAX
  CALL ShowWindow
  
  POP EAX  
  PUSH EAX
  CALL UpdateWindow
  
  PUSH [ghWnd]
  CALL SetFocus
  
  CALL Plasma_InitDirectX
  CALL Plasma_SetPalette
  CALL Plasma_InitTrigTables
  
  CALL GetCurrentProcess
;  
;  These make the plasma smoother since we will hog the CPU. 
;
;  The "REALTIME" make it almost impossible to exit though.
;


;  PUSH REALTIME_PRIORITY_CLASS
  PUSH HIGH_PRIORITY_CLASS
  PUSH EAX
  CALL SetPriorityClass
  
  CALL GetCurrentThread
  
;  PUSH THREAD_PRIORITY_TIME_CRITICAL
  PUSH THREAD_PRIORITY_ABOVE_NORMAL
  PUSH EAX
  CALL SetThreadPriority
  
  CMP [bPlasmaOk], 0
  JE SHORT @Plasma_ExitProcess
  
 @Plasma_MessageLoop:
 
        PUSH PM_REMOVE
        PUSH 0
        PUSH 0
        PUSH 0
        PUSH OFFSET Msg
        CALL PeekMessage
  
        TEST EAX, EAX
        JZ SHORT @Plasma_PerformPlasmaDemo

                CMP [Msg.message], WM_QUIT
                JE SHORT @Plasma_ExitProcess
                
;                CMP [Msg.message], WM_KEYDOWN
;                JNE SHORT @Plasma_SendToWindow
                
;                CMP [Msg.wParam], VK_ESCAPE
;                JE SHORT @Plasma_ExitProcess
                
               @Plasma_SendToWindow:
                PUSH OFFSET Msg
                CALL TranslateMessage
  
                PUSH OFFSET Msg
                CALL DispatchMessage
                
                JMP SHORT @Plasma_MessageLoop
                
       @Plasma_PerformPlasmaDemo:
;                CALL GetFocus
                
;                CMP EAX, [ghWnd]
;                JNE @Plasma_MessageLoop
                
                CALL Plasma_Plasma
                
  JMP SHORT @Plasma_MessageLoop

 @Plasma_ExitProcess:
  
  CALL Plasma_UnInitDirectX
  
  PUSH 0
  CALL ExitProcess



;*********************************************************
; Plasma_InitVars
;
;
;  Initializes Variables - Bad Attempt to save space.
;
;*********************************************************
Plasma_InitVars PROC
  MOV EAX, OFFSET PlasmaDynamicV1
  
  MOV DWORD PTR [EAX], 0
  MOV DWORD PTR [EAX + 4], 040240000h

  MOV EAX, OFFSET PlasmaDynamicV2
  
  MOV DWORD PTR [EAX], 0
  MOV DWORD PTR [EAX + 4], 040490000h

  MOV EAX, OFFSET PlasmaDynamicInc1
  
  MOV DWORD PTR [EAX], 0
  MOV DWORD PTR [EAX + 4], 040160000h

  MOV EAX, OFFSET PlasmaDynamicInc2
  
  MOV DWORD PTR [EAX], 0
  MOV DWORD PTR [EAX + 4], 040240000h
  
  MOV EAX, OFFSET Radians
  
  MOV DWORD PTR [EAX], 0a2529d39h
  MOV DWORD PTR [EAX + 4], 03f91df46h  
  
  MOV EAX, OFFSET pszWindowClass
  
  MOV DWORD PTR [EAX], 00736554h           ; Truncate The Class Name, who cares about it?
  
  RET
Plasma_InitVars ENDP

;*********************************************************
; Plasma_InitTrigTables
;
;
;  Initializes Direct X
;
;*********************************************************
Plasma_InitTrigTables PROC
  
  MOV EDI, OFFSET SinTable
  MOV ESI, OFFSET CosTable
  
  XOR ECX, ECX
  
 @Plasma_InitTrigLoop:
    
    MOV [Temp1], ECX
    
    FILD [Temp1]
    FLDPI
    FMUL
    MOV [Temp1], 180
    FILD [Temp1]
    ; FST [Temp1]       ; Saveing the value here causes all COS() to be from 180 rads.  
                        ;  Gives different effect and can be optimized more
    FDIV
    FST [Temp1]
    
    FSIN
    FSTP QWORD PTR [EDI + ECX*SIZE QWORD]
    
    FLD [Temp1]
    FCOS
    FSTP QWORD PTR [ESI + ECX*SIZE QWORD]
    

    INC ECX
    
    CMP ECX, 360
    JB SHORT @Plasma_InitTrigLoop
 
  RET
Plasma_InitTrigTables ENDP

;*********************************************************
; Plasma_InitDirectX
;
;
;  Initializes Direct X
;
;*********************************************************
Plasma_InitDirectX PROC
  
  MOV [bPlasmaOk], 0
  
  PUSH 0
  PUSH OFFSET lpDirectDraw
  PUSH 0
  CALL DirectDrawCreate

  CMP EAX, 0
  JL @Plasma_Failed
  
  MOV EBX, [lpDirectDraw]
  
  PUSH 0
  PUSH EBX
  MOV  EAX, [EBX]
  CALL DWORD PTR [EAX + DDRAWDD_Initialize]
  
  PUSH DDSCL_FULLSCREEN or DDSCL_ALLOWMODEX or DDSCL_EXCLUSIVE or DDSCL_ALLOWREBOOT
  PUSH [ghWnd]
  PUSH EBX
  MOV  EAX, [EBX]
  CALL DWORD PTR [EAX + DDRAWDD_SetCooperativeLevel]
    
  PUSH SCREEN_COLORDEPTH
  PUSH SCREEN_HEIGHT
  PUSH SCREEN_WIDTH
  PUSH EBX
  MOV  EAX, [EBX]
  CALL DWORD PTR [EAX + DDRAWDD_SetDisplayMode]  
    
  MOV EDI, OFFSET DSurfaceDesc
  MOV ECX, SIZE DDSURFACEDESC
  XOR EAX, EAX
  REP STOSB
  
  MOV [DSurfaceDesc.dwSize],  SIZE DDSURFACEDESC
  MOV [DSurfaceDesc.dwFlags], DDSD_CAPS or DDSD_BACKBUFFERCOUNT
  MOV [DSurfaceDesc.ddsCaps], DDSCAPS_PRIMARYSURFACE or DDSCAPS_COMPLEX or DDSCAPS_FLIP
  MOV [DSurfaceDesc.dwBackBufferCount], 1
  
  MOV EDI, OFFSET DSurfaceDesc

  PUSH 0
  PUSH OFFSET lpDirectDrawSurface
  PUSH OFFSET DSurfaceDesc
  PUSH EBX
  MOV EAX, [EBX]
  CALL DWORD PTR [EAX + DDRAWDD_CreateSurface]  
  
  CMP EAX, 0
  JL @Plasma_Failed
  
  MOV [DSurfaceCaps], DDSCAPS_BACKBUFFER
  
  PUSH OFFSET lpDirectBackSurface
  PUSH OFFSET DSurfaceCaps
  PUSH [lpDirectDrawSurface]
  MOV EAX, [lpDirectDrawSurface]
  MOV EAX, [EAX]
  CALL DWORD PTR [EAX + DDRAWDD_Surface_GetAttachedSurface]
  
  CMP EAX, 0
  JL @Plasma_Failed
  
  MOV [bPlasmaOk], 1
  
 @Plasma_Failed:
  RET
Plasma_InitDirectX ENDP


;*********************************************************
; Plasma_UnInitDirectX
;
;
;  UnInitializes Direct X
;
;*********************************************************
Plasma_UnInitDirectX PROC

  MOV EAX, [lpDirectDrawSurface]
  
  TEST EAX, EAX
  JZ SHORT @Plasma_FreeDirectDraw
  
  PUSH EAX
  MOV EAX, [EAX]
  CALL DWORD PTR [EAX + DDRAWDD_Surface_Release]

 @Plasma_FreeDirectDraw:
  MOV EAX, [lpDirectDraw]
  
  TEST EAX, EAX
  JZ SHORT @Plasma_ExitDirectX
  
  PUSH EAX
  MOV EAX, [EAX]
  CALL DWORD PTR [EAX + DDRAWDD_Release]
 
 @Plasma_ExitDirectX:
  
  MOV [lpDirectDraw], 0
  MOV [lpDirectDrawSurface], 0
  MOV [lpDirectBackSurface], 0
  
  RET
Plasma_UnInitDirectX ENDP

;*********************************************************
; Plasma_Plasma
;
;
;  Does the Plasma
;
;*********************************************************
Plasma_Plasma PROC
  
  PUSH 0
  PUSH DDLOCK_SURFACEMEMORYPTR or DDLOCK_WAIT
  PUSH OFFSET DSurfaceDesc
  PUSH 0
  PUSH [lpDirectBackSurface]
  MOV EAX, [lpDirectBackSurface]
  MOV EAX, [EAX]
  CALL DWORD PTR [EAX + DDRAWDD_Surface_Lock]
  
  CMP EAX, 0
  JL @Plasma_FailedToDraw
    
  MOV EAX, [DSurfaceDesc.lpSurface]
  MOV [pVideoBuffer], EAX
  
  MOV EAX, [DSurfaceDesc.lPitch]
  MOV [lPitch], EAX
  MOV [lPitch2], EAX
  ADD [lPitch2], EAX
  
;  MOV EDI, [pVideoBuffer]   Clear Buffer
  
;  MOV ECX, SCREEN_HEIGHT
  
; @loophere:
;  PUSH ECX
;  MOV ECX, SCREEN_WIDTH/2
;  XOR EAX, EAX
;  REP STOSD
;  MOV ECX, [lPitch]
;  SUB ECX, SCREEN_WIDTH*2
;  
;  ADD EDI, ECX
;  POP ECX
;  LOOP @loophere

  CALL Plasma_DoPlasma

;  MOV ESI, OFFSET Mybuffer                              ; I am doing 1/2 a screen and blowing it up a full screen
;  MOV EDI, [DSurfaceDesc.lpSurface]
;  MOV EBX, [DSurfaceDesc.lPitch]
;  MOV ECX, 0
  
; @Plasma_CopyBufferToScreen:
;  PUSH ECX
;  XOR ECX, ECX
;  PUSH EDI
;  @Plasma_CopyXRow:
  
;        MOV DX, [ESI + ECX]
;        MOV AX, DX
;        SHL EAX, 16
;        MOV AX, DX
;        STOSD
;  
;        ADD ECX, 2
;        
;        CMP ECX, SCREEN_WIDTH
;        JB SHORT @Plasma_CopyXRow
;   
;   POP EDI
;   POP ECX
;   
;   ADD EDI, EBX
;   
;   TEST ECX, 1
;   JZ @Plasma_DoNotIncrementYet
;   
;   ADD ESI, SCREEN_WIDTH
;   
;  @Plasma_DoNotIncrementYet:
;  
;   INC ECX
;   CMP ECX, SCREEN_HEIGHT
;   JNE SHORT @Plasma_CopyBufferToScreen
  
  PUSH 0
  PUSH [lpDirectBackSurface]
  MOV EAX, [lpDirectBackSurface]
  MOV EAX, [EAX]
  CALL DWORD PTR [EAX + DDRAWDD_Surface_Unlock]  
   
 @Plasma_FlipScreen:
 
  PUSH DDFLIP_WAIT
  PUSH 0
  PUSH [lpDirectDrawSurface]
  MOV EAX, [lpDirectDrawSurface]
  MOV EAX, [EAX]
  CALL DWORD PTR [EAX + DDRAWDD_Surface_Flip]
  
  TEST EAX, EAX
  JNZ SHORT @Plasma_FlipScreen
  
 @Plasma_FailedToDraw:
     
  RET
Plasma_Plasma ENDP




;*********************************************************
; Plasma_Cos
;
;
;  Do The Plasma
;
;*********************************************************
Plasma_Cos PROC

  FISTP [Temp5]
   
  MOV EDX, [Temp5]
  
  CMP EDX, 360
  JB @Plasma_No360COS
  
  XOR EDX, EDX
  MOV EAX, 360
  XCHG EAX, [Temp5]
  DIV [Temp5]

  
 @Plasma_No360COS:
 
  MOV EAX, OFFSET CosTable       
  FLD QWORD PTR [EAX + EDX*SIZE QWORD]

  RET
Plasma_Cos ENDP



;*********************************************************
; Plasma_Sin
;
;
;  Do The Plasma
;
;*********************************************************
Plasma_Sin PROC

  FISTP [Temp5]
   
  MOV EDX, [Temp5]
  
  CMP EDX, 360
  JB @Plasma_No360SIN
  
  XOR EDX, EDX
  MOV EAX, 360
  XCHG EAX, [Temp5]
  DIV [Temp5]
  
 @Plasma_No360SIN:
 
  MOV EAX, OFFSET SinTable       

  FLD QWORD PTR [EAX + EDX*SIZE QWORD]
 
  RET
Plasma_Sin ENDP


;*********************************************************
; Plasma_DoPlasma
;
;
;  Do The Plasma
;
;   NOTE: This is unoptimized.  Uses the FPU and the math
;         was never evaluated to be optimized using math
;         properties. The SIN/COS are in lookup tables just
;         to get around conversion to radians.
; 
;         POSSIBLE FUTURE ENHANCEMENTS:
;             1) Evaluate math equation for optimization in formula
;             2) Fixed point integer math
;
;
;*********************************************************
Plasma_DoPlasma PROC
  
  MOV EDI, [pVideoBuffer]
  MOV ESI, OFFSET Palette
  
;  MOV EAX, 104
;  MOV [Temp5], EAX  This was to validate the FPU stack was kept clean
;  FILD [Temp5]
  
  FLD [PlasmaDynamicV1]
  
  FMUL [Radians]
  
  FSTP [DV1]                        ; Temp 1 = Radians of PlasmaDynamicV1 Value
  MOV [Temp3], 15
  FILD [Temp3]
  FDIV [DV1]
  FSTP [DV1]
  
  FLD [PlasmaDynamicV2]
  FMUL [Radians]
  
  FSTP [DV2]                        ; Temp 1 = Radians of PlasmaDynamicV2 Value
  MOV [Temp3], 25
  FILD [Temp3]
  FDIV [DV2]
  FSTP [DV2]
  
  XOR EBX, EBX
  
 @Plasma_LoopForHeight:  
    
    XOR ECX, ECX
    
    MOV [Temp1], EBX
    FILD [Temp1]
    FMUL [Radians]
    FSTP [IndexY]                        ; Temp 1 = Radians of Y Value
    
    FILD [Temp1]
    FSTP [IndexY1]
    
   @Plasma_LoopForWidth:
       MOV [Temp2], ECX
       FILD [Temp2]
       
       FMUL [Radians]        
       
       FSTP [IndexX]                        ; Temp 2 = Radians of X Value       
       
       FILD [Temp2]
       FSTP [IndexX1]
       
       ; X values
       
       ; cos(a + b + c)*(20*ar + 15)
       FLD [IndexY1]
        
       FADD [PlasmaDynamicV1]
       FADD [PlasmaDynamicV2]
       
       CALL Plasma_Cos
       
       MOV [Temp5], 20
       FILD [Temp5]
             
       FMUL [IndexY]
       
       MOV [Temp5], 15
       FILD [Temp5]       
       
       FADD 
       
       FMUL
       
       ; cos(b + a*2)*9*ar 
       MOV [Temp5], EBX
       SHL [Temp5], 1
       FILD [Temp5]
        
       FADD [PlasmaDynamicV1]
        
       
       CALL Plasma_Cos
       MOV [Temp5], 9
       FILD [Temp5]
       FMUL       
       FMUL [IndexY]
        
       FADD       

       ; cos(a + c)*15
       FLD [IndexX1]
       FADD [PlasmaDynamicV2]
        
       CALL Plasma_Cos
       MOV [Temp5], 15
       FILD [Temp5]
        
       FMUL       
        
       FADD       


       ; sin(c)*15/br
       FLD [PlasmaDynamicV2]
       CALL Plasma_Sin
       
       FMUL [DV1]
        
       FADD       
 
       ; Y Values

       ; sin(a + b + c)*(15*ar + 20)
       FLD [IndexY1]
       FADD [PlasmaDynamicV1]
       FADD [PlasmaDynamicV2]
       
       CALL Plasma_Sin
       
       MOV [Temp5], 15
       FILD [Temp5]
        
       FMUL [IndexX]
       
       MOV [Temp5], 20
       FILD [Temp5]
       
       FADD
       
       FMUL
        
       FADD
               
       ; sin(c + a*2)*8
       MOV [Temp5], EBX
       SHL [Temp5], 1
       FILD [Temp5]
        
       FADD [PlasmaDynamicV2]
        
       CALL Plasma_Sin
       MOV [Temp5], 8
       FILD [Temp5]
       FMUL       
        
       FADD       
 
       ; sin(a + b)*15 
       FLD [IndexX1]
       FADD [PlasmaDynamicV1]
        
       CALL Plasma_Sin
       MOV [Temp5], 15
       FILD [Temp5]
       FMUL       
        
       FADD       
 

       ; cos(b)*25/cr
       FLD [PlasmaDynamicV1]
       CALL Plasma_Sin

       FMUL [DV2]
       
       FADD      
 
       FISTP [Temp5]

       MOV EAX, [Temp5]
       AND EAX, 0FFh

       
       MOV DX, [ESI + EAX*2]
       
       MOV AX, DX
       SHL EDX, 16
       MOV DX, AX
       
       
       MOV EAX, [lPitch]
       ADD EAX, EDI
       MOV [EDI + ECX*4], EDX
       MOV [EAX + ECX*4], EDX
       
       INC ECX
       CMP ECX, 320
       JB @Plasma_LoopForWidth
   
   ADD EDI, [lPitch2]

   INC EBX
   CMP EBX, 240
   JB @Plasma_LoopForHeight


  FLD [PlasmaDynamicInc1]
  FADD [PlasmaDynamicV1]
  FSTP [PlasmaDynamicV1]

  FLD [PlasmaDynamicInc2]
  FADD [PlasmaDynamicV2]
  FSTP [PlasmaDynamicV2]
  
  
;  FISTP [Temp5]  
;  CMP [Temp5], 104
;  JE SHORT @Plasma_Correct  This was to validate the FPU stack was kept clean
;  INT 3
@Plasma_Correct:  
  
  RET
Plasma_DoPlasma ENDP



;*********************************************************
; Plasma_SetPalette
;
;
;  Set The Palette
;
;*********************************************************
Plasma_SetPalette PROC
  PUSH EBP
  MOV EBP, ESP
  SUB ESP, 0Ch
  
  MOV DWORD PTR [EBP - 4], 0                              ; Red
  MOV DWORD PTR [EBP - 8], 0                              ; Green
  MOV DWORD PTR [EBP - 0Ch], 0                            ; Blue
  
  MOV EDI, OFFSET Palette
  
  XOR ECX, ECX
  XOR EDX, EDX
  
 @Plasma_LoopSetPal:
    MOV AX, [EBP - 4]
    AND AX, 01fh
    MOV BX, [EBP - 8]
    AND BX, 03fh
    SHL AX, 11
    SHL BX, 5
    OR AX, BX
    MOV BX, [EBP - 0ch]
    AND BX, 01fh
    OR AX, BX
    MOV [EDI], AX
    ADD EDI, 2
 
    CMP ECX, 31
    SETE AL
    ADD DL, AL
    
    CMP ECX, 62
    SETE AL
    ADD DL, AL
    
    CMP ECX, 93
    SETE AL
    ADD DL, AL
    
    CMP ECX, 124
    SETE AL
    ADD DL, AL
    
    CMP ECX, 155
    SETE AL
    ADD DL, AL
    
    CMP ECX, 186
    SETE AL
    ADD DL, AL

    CMP ECX, 217
    SETE AL
    ADD DL, AL

    CMP ECX, 248
    SETE AL
    ADD DL, AL
    
    
    CMP DL, 0
    JE SHORT @Plasma_MakeBlue
    
    CMP DL, 1
    JE SHORT @Plasma_TakeBlue
    
    CMP DL, 2
    JE SHORT @Plasma_MakeRed
    
    CMP DL, 3
    JE SHORT @Plasma_TakeRed
    
    CMP DL, 4
    JE SHORT @Plasma_MakeYellow
    
    CMP DL, 5
    JE SHORT @Plasma_TakeYellow
    
    CMP DL, 6
    JE SHORT @Plasma_MakeRedGreenBlue
    
    CMP DL, 7
    JE SHORT @Plasma_TakeRedGreenBlue   
    
    JMP SHORT @Plasma_DefaultHandler
    
   @Plasma_MakeBlue:
    ADD DWORD PTR [EBP - 0Ch], 1
    JMP SHORT @Plasma_AnotherLoop
    
   @Plasma_TakeBlue:
    SUB DWORD PTR [EBP - 0Ch], 1
    JMP SHORT @Plasma_AnotherLoop
    
   @Plasma_MakeRed:
    ADD DWORD PTR [EBP - 04h], 1
    JMP SHORT @Plasma_AnotherLoop
    
   @Plasma_TakeRed:
    SUB DWORD PTR [EBP - 04h], 1
    JMP SHORT @Plasma_AnotherLoop
    
   @Plasma_MakeYellow:
    ADD DWORD PTR [EBP - 04h], 1
    ADD DWORD PTR [EBP - 08h], 1
    JMP SHORT @Plasma_AnotherLoop
    
   @Plasma_TakeYellow:
    SUB DWORD PTR [EBP - 04h], 1
    SUB DWORD PTR [EBP - 08h], 1
    JMP SHORT @Plasma_AnotherLoop
    
   @Plasma_MakeRedGreenBlue:
    ADD DWORD PTR [EBP - 04h], 1
    ADD DWORD PTR [EBP - 08h], 2
    ;ADD DWORD PTR [EBP - 0Ch], 1
    JMP SHORT @Plasma_AnotherLoop
    
   @Plasma_TakeRedGreenBlue:
    SUB DWORD PTR [EBP - 04h], 1
    SUB DWORD PTR [EBP - 08h], 2
    ;SUB DWORD PTR [EBP - 0Ch], 1
    JMP SHORT @Plasma_AnotherLoop    
    
   @Plasma_DefaultHandler:
    MOV DWORD PTR [EBP - 4], 0                              ; Red
    MOV DWORD PTR [EBP - 8], 0                              ; Green
    MOV DWORD PTR [EBP - 0Ch], 0                            ; Blue    
    
   @Plasma_AnotherLoop: 
    INC ECX
    CMP ECX, 256
    JB @Plasma_LoopSetPal
    
  ADD ESP, 0Ch
  POP EBP
  RET
Plasma_SetPalette ENDP



;*********************************************************
; Plasma_RegisterWindow
;
;
;  Registers The Window Class
;
;*********************************************************
Plasma_RegisterWindow PROC
  
  MOV ECX, SIZE WNDCLASSEX
  XOR EAX, EAX
  MOV EDI, OFFSET WndClassEx
  REP STOSB                                                     ; Clear Window Class

  MOV EAX, [hInstance]
  MOV [WndClassEx.hInstance], EAX
  MOV [WndClassEx.lpfnWndProc], OFFSET Plasma_WindowProcedure
  MOV [WndClassEx.lpszClassName], OFFSET pszWindowClass
  MOV [WndClassEx.cbSize], SIZE WNDCLASSEX

  PUSH OFFSET WndClassEx
  CALL RegisterClassEx
  RET
  
Plasma_RegisterWindow ENDP



;*********************************************************
; Plasma_CreateWindow
;
;
;  Creates The Window 
;
;*********************************************************
Plasma_CreateWindow PROC
    PUSH  0
    PUSH  [hInstance]
    PUSH  0
    PUSH  0
    PUSH  SCREEN_HEIGHT
    PUSH  SCREEN_WIDTH
    PUSH  0
    PUSH  0
    PUSH  WS_POPUP
    PUSH  0
    PUSH  OFFSET pszWindowClass
    PUSH  0
    CALL CreateWindowEx
    RET
Plasma_CreateWindow ENDP
  

;*********************************************************
; Plasma_WindowProcedure
;   
;   The Window Procedure
;   
;
;*********************************************************
Plasma_WindowProcedure PROC hWnd:DWORD, wMsg:DWORD, wParam:DWORD, lParam:DWORD  
  
  MOV EAX, [wMsg]
  
  CMP EAX, WM_CREATE
  JE SHORT @Plasma_HandleCreate
  
  CMP EAX, WM_KEYUP
  JE SHORT @Plasma_HandleKeyUp
  
  CMP EAX, WM_DESTROY
  JE SHORT @Plasma_DestroyWindow
  
  CMP EAX, WM_CLOSE
  JE SHORT @Plasma_CloseWindow
  
  JMP SHORT @Plasma_DefaultWindow
  PUSH 0
  CALL PostQuitMessage
  RET
  
 @Plasma_HandleCreate:
  PUSH 0
  CALL ShowCursor
  
  PUSH [hWnd]
  CALL SetFocus
 
  XOR EAX, EAX
  JMP SHORT @Plasma_ExitWindowsProc 
  
 @Plasma_HandleKeyUp:
  
  CMP [wParam], VK_ESCAPE
  JNE SHORT @Plasma_DefaultWindow
  
  PUSH [hWnd]
  CALL DestroyWindow
  
  XOR EAX, EAX
  JMP SHORT @Plasma_ExitWindowsProc 
  
 @Plasma_DestroyWindow:
 @Plasma_CloseWindow:
  PUSH 1
  CALL ShowCursor
  
  PUSH 0
  CALL PostQuitMessage
  
  XOR EAX, EAX
  JMP SHORT @Plasma_ExitWindowsProc 
   
 @Plasma_DefaultWindow:
  PUSH [lParam]
  PUSH [wParam]
  PUSH [wMsg]
  PUSH [hWnd]
  CALL DefWindowProc
  
 @Plasma_ExitWindowsProc:
  RET
Plasma_WindowProcedure ENDP

  
END Plasma_EntryPoint


