/***********************************************************************
 * oglcube.c
 *  
 *    Open GL Cube
 *
 *
 * Toby Opferman Copyright (c) 2004
 *
 ***********************************************************************/
 
//#define SPHERE_DEMO
 
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "oglcube.h"
 
#define OPENGL_OBJECT  1
 
#define BLACK_INDEX     0 
#define RED_INDEX       13 
#define GREEN_INDEX     14 
#define BLUE_INDEX      16

#define NEAR_PLANE      3.0
#define FAR_PLANE       7.0
#define MAX_OBJECT_SIZE 60.0
#define RADIUS         (NEAR_PLANE + MAX_OBJECT_SIZE/2.0)

#define CUBE_SIZE .5

#define FACE(a, b, c, d) \
          glBegin(GL_LINE_STRIP); \
            glVertex3f(g_Cube[a][0], g_Cube[a][1], g_Cube[a][2]); \
            glVertex3f(g_Cube[b][0], g_Cube[b][1], g_Cube[b][2]); \
            glVertex3f(g_Cube[c][0], g_Cube[c][1], g_Cube[c][2]); \
            glVertex3f(g_Cube[d][0], g_Cube[d][1], g_Cube[d][2]); \
            glVertex3f(g_Cube[a][0], g_Cube[a][1], g_Cube[a][2]); \
          glEnd(); 

 GLfloat g_ColorDiffuse[] = { (GLfloat)0.32, (GLfloat)0.3, (GLfloat)0.55, (GLfloat)0.23};
                               /*   X      Y      Z   */
 GLdouble g_Cube[8][3] =       { {-CUBE_SIZE,  CUBE_SIZE, -CUBE_SIZE },
                                { CUBE_SIZE,  CUBE_SIZE, -CUBE_SIZE },
                                {-CUBE_SIZE,  CUBE_SIZE,  CUBE_SIZE },
                                { CUBE_SIZE,  CUBE_SIZE,  CUBE_SIZE },
                                {-CUBE_SIZE, -CUBE_SIZE, -CUBE_SIZE },
                                { CUBE_SIZE, -CUBE_SIZE, -CUBE_SIZE },
                                {-CUBE_SIZE, -CUBE_SIZE,  CUBE_SIZE },
                                { CUBE_SIZE, -CUBE_SIZE,  CUBE_SIZE } };


 
 /*
  *  The Cube
  *
  *        0----1
  *      / |   /  
  *     2--+-3  |
  *     |/ 4-+--5
  *     6----7/  
  *
         
  
  */

 UINT g_Faces[6][4] = {   { 0, 1, 3, 2 },
                          { 0, 4, 5, 1 },
                          { 2, 3, 7, 6 },
                          { 3, 1, 5, 7 },
                          { 4, 5, 7, 6 },
                          { 0, 2, 6, 4 } };

 GLdouble g_Normals[6][3] =    { {  0.0, 1.0,  0.0 },
                                {  0.0,  0.0,  -1.0 },
                                {  0.0,  0.0, 1.0 },
                                {  1.0,  0.0,  0.0 },
                                {  0.0,  -1.0,  0.0 },
                                {  -1.0,  0.0,  0.0} } ;

 
 DWORD WINAPI FunctionLoop(PVOID pVoid);


 /***********************************************************************
  *  Prototype Functions
  ***********************************************************************/
  void OGLCube_CreatePixelFormat(HDC hDC);

  HWND g_hWnd;
  HGLRC g_hGLRC;

 /***********************************************************************
  * OGLCube_Create
  *  
  *    Create the instance of the cube
  *
  * Parameters
  *     None
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
  void OGLCube_Create(HWND hWnd)
  {
      HGLRC hDCOGL;
      RECT Rect;
      DWORD dwThread;
      //GLfloat GLAspect;
      HDC hDC;
      g_hWnd = hWnd;

      hDC = GetDC(hWnd);

      OGLCube_CreatePixelFormat(hDC);

      g_hGLRC = hDCOGL = wglCreateContext(hDC); 

      wglMakeCurrent(hDC, hDCOGL);

      ReleaseDC(hWnd, hDC);
      CreateThread(NULL, 0, (PVOID)FunctionLoop, (PVOID)NULL, 0, &dwThread);

      GetClientRect(hWnd, &Rect); 

      glClearIndex( (GLfloat)BLACK_INDEX); 
      glClearDepth( 1.0 );
      glEnable(GL_DEPTH_TEST); 
      glCullFace(GL_BACK);
	  

      //GLAspect = (GLfloat) Rect.right/Rect.bottom;
 
      glMatrixMode( GL_PROJECTION ); 
      gluPerspective( 45.0, 0.0, NEAR_PLANE, FAR_PLANE); 
      glMatrixMode( GL_MODELVIEW );

      glNewList(OPENGL_OBJECT, GL_COMPILE);
          
#ifndef SPHERE_DEMO
      {
         UINT uiIndexNormals;
         UINT uiIndexFaces;
         GLfloat GLRed, GLGreen, GLBlue;
 /*
  *  The Cube
  *
  *        0----1
  *      / |   /  
  *     2--+-3  |
  *     |/ 4-+--5
  *     6----7/  
  *
  */

         GLRed = 1.0;
         GLGreen = 1.0;
         GLBlue = 0;

          
         glBegin(GL_QUADS);

	     for(uiIndexNormals = 0; uiIndexNormals < 6; uiIndexNormals++)
         {
            glColor3f(GLRed, GLGreen, GLBlue);

            GLRed -= (GLfloat)0.1;
            GLGreen -= (GLfloat)0.2;
            GLBlue += (GLfloat)0.2;

		    glNormal3dv(g_Normals[uiIndexNormals]);

		    for(uiIndexFaces=0; uiIndexFaces < 4; uiIndexFaces++)
            {
		        glVertex3dv(g_Cube[g_Faces[uiIndexNormals][uiIndexFaces]]);
		    }
         }

         glEnd();

      }
#else
      {
        GLUquadricObj *quadObj; 
        quadObj = gluNewQuadric (); 
        gluQuadricDrawStyle (quadObj, GLU_LINE); 
        gluSphere(quadObj, .5, 15, 15);
      }
#endif


      glEndList();
  }


 /***********************************************************************
  * OGLCube_Create
  *  
  *    Create the instance of the cube
  *
  * Parameters
  *     None
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
  void OGLCube_CreatePixelFormat(HDC hDC)
  {

     PIXELFORMATDESCRIPTOR pfd = {0}, *ppfd; 
     int pixelformat; 
 
     ppfd = &pfd; 
 
     ppfd->nSize = sizeof(PIXELFORMATDESCRIPTOR); 
     ppfd->nVersion = 1; 
     ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER; 
     ppfd->dwLayerMask = PFD_MAIN_PLANE; 
     ppfd->iPixelType = PFD_TYPE_RGBA; 
     ppfd->cColorBits = 24; 
     ppfd->cDepthBits = 16; 
 
 
     pixelformat = ChoosePixelFormat(hDC, ppfd); 
     SetPixelFormat(hDC, pixelformat, ppfd);

  }

 /***********************************************************************
  * OGLCube_Create
  *  
  *    Create the instance of the cube
  *
  * Parameters
  *     None
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
  void OGLCube_Draw(HWND hWnd)
  {
      static GLfloat RotateX = 0, RotateY = 0, RotateZ = 0;
      HDC hDC = GetDC(hWnd);
      int iIndex = 0;

      RotateX += .5;
      RotateY += .5;
      RotateZ += .5;
      glRenderMode(GL_RENDER);
      glClearColor(0.0,0.0,0.0,0.0);
      glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
     
      glPushMatrix();

      glRotated(RotateZ, 0.0, 0.0, 1.0); 
      glRotated(RotateY, 0.0, 1.0, 0.0);
      glRotated(RotateX, 1.0, 0.0, 0.0); 
     

      //glEnable(GL_LIGHTING);
      //glEnable(GL_LIGHT0);
       
    //  for(iIndex = 0; iIndex < 500; iIndex++)
      {
      
          glColor4i(0, 0, 0, 0);

      }
      glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE, g_ColorDiffuse);
      
      glCallList(OPENGL_OBJECT);

      //glDisable(GL_LIGHT0);
      //glDisable(GL_LIGHTING);

      glPopMatrix();
      
      glFlush();

      SwapBuffers(hDC);

      ReleaseDC(hWnd, hDC);
  }


DWORD WINAPI FunctionLoop(PVOID pVoid)
{
     static GLfloat RotateX = 0, RotateY = 0, RotateZ = 0;
     HDC hDC = GetDC(g_hWnd);
     int iIndex = 0;
     OGLCube_CreatePixelFormat(hDC);

         wglMakeCurrent(hDC, g_hGLRC);
     ReleaseDC(g_hWnd, hDC);

     while(1)
     {
     
        glPushMatrix();

      glRotated(RotateZ, 0.0, 0.0, 1.0); 
      glRotated(RotateY, 0.0, 1.0, 0.0);
      glRotated(RotateX, 1.0, 0.0, 0.0); 
     

      //glEnable(GL_LIGHTING);
      //glEnable(GL_LIGHT0);
       
    //  for(iIndex = 0; iIndex < 500; iIndex++)
      {
      
          glColor4i(0, 0, 0, 0);

      }
      glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE, g_ColorDiffuse);
      
      glCallList(OPENGL_OBJECT);

      //glDisable(GL_LIGHT0);
      //glDisable(GL_LIGHTING);

      glPopMatrix();
      Sleep(100);
     }

}




