/***********************************************************************
 * TestAudio.C
 *  
 *    Application to test the audio library
 *
 *
 * Toby Opferman Copyright (c) 2002
 *
 ***********************************************************************/
 
 
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <taudio.h>
 
 
 /***********************************************************************
  * main
  *
  *    Entry Point For console Applications
  *
  * Parameters
  *     Standard console Entry Point Parameters
  * 
  * Return Value
  *     Result of the program
  *
  ***********************************************************************/
 int __cdecl main(UINT argc, char **argv)
 {
	 HTAUDIO hTAudioBackground;
	 HTAUDIO hSoundEffect;
     int iChar;
	 char *pszBackgroundMusic;
	 char **pszEffects;
	 UINT uiEffectNumber;

	 if(argc > 1)
	 {
		 pszBackgroundMusic = argv[1];
		 pszEffects         = &argv[2];
		 hTAudioBackground = TAudio_Init(&pszBackgroundMusic, 1, FLAG_LOOP_SOUND);
		 hSoundEffect      = TAudio_Init(pszEffects, argc - 2, 0);

		 TAudio_PlaySound(hTAudioBackground, 0);

		 uiEffectNumber = 0;

		 do { 
			 printf("Press a key to create a sound effect or q to quit\n");
			 iChar = getchar();
			 TAudio_PlaySound(hSoundEffect, uiEffectNumber);
			 uiEffectNumber++;

			 if(uiEffectNumber >= argc - 2)
			 {
				 uiEffectNumber = 0;
			 }

		 } while(iChar != 'q' && iChar != 'Q');
	 }

	     
     return 0;
 }





