;-------------------
; Toby Opferman
; _Secret
; http://www.nauticom.net/www/secret
; secret@pgh.nauticom.net
;-------------------

.MODEL TINY
.186

.CODE
 ORG 100h
START:
 LOCALS
 PUSH CS
 POP DS
 MOV BH, 0A0h
 MOV ES, BX

 MOV AL, 13h
 INT 10h


 CALL SEED
 CALL SETPAL
 CALL CLEARBUFFER

 CALL FIRE
 CALL DITHER
 CALL TRI
 CALL BLOWUP
 CALL FADEOUT
 CALL CLEARBUFFER
 XOR AX, AX
 XOR DI, DI
 MOV CX, 32000
 REP STOSW
 CALL SNOW
 CALL DITHER

 MOV AX, 3
 INT 10h

 MOV DX, Offset EndMsg
 MOV AH, 9
 INT 21h

 INT 20h

CLEARBUFFER PROC
 MOV DI, Offset DoubleBuffa
 PUSH ES
 PUSH CS
 POP ES
 MOV CX, 32000
 CALL RETRACE
 XOR AX, AX
 REP STOSW
 POP ES
 RET
ENDP CLEARBUFFER


SETPAL PROC
  MOV CX, 0FFh                  ; Set The Pallete
  MOV DX, 03C8h                 
  MOV DI, Offset DoubleBuffa+765

  SETPALLETE:
  MOV AL, CL
  OUT DX, AL
  INC DX
  MOV AL, [DI]
  SHR AL, 1
  OUT DX, AL
  INC DI
  MOV AL, [DI]

  SHR AL, 1
  OUT DX, AL
  INC DI
  MOV AL, [DI]
  SHR AL, 1
  OUT DX, AL
  SUB DI, 5
  DEC DX
  LOOP SETPALLETE
  RET
ENDP SETPAL

DITHER PROC
 MOV CX, 160
 MOV AX, 319
 MOV BX, 0
 D:
 PUSH CX
 MOV DI, Offset DoubleBuffa
 ADD DI, AX
 MOV CX, 200
 @ONE:
 MOV BYTE PTR [DI], 0
 ADD DI, 320
 LOOP @ONE

 MOV DI, Offset DoubleBuffa
 ADD DI, BX
 MOV CX, 200
 @TWO:
 MOV BYTE PTR [DI], 0
 ADD DI, 320
 LOOP @TWO
 MOV SI, Offset DoubleBuffa
 XOR DI, DI
 MOV CX, 32000
 PUSH AX
 CALL RETRACE
 POP AX
 REP MOVSW
 SUB AX, 2
 ADD BX, 2
 POP CX
 LOOP D
 RET
ENDP DITHER

RETRACE PROC
 MOV DX, 03DAh
 FIRST:
 IN AL, DX
 TEST AL, 8
 JNZ FIRST
 SECOND:
 IN AL, DX
 TEST AL, 8
 JZ SECOND
 RET
ENDP RETRACE

BLOWUP PROC

 KEEPGOING:
 XOR CX, CX
 XOR BX, BX
 CALL RETRACE
 MOV DX, 03C7h
 JUMPHERE:
 MOV AL, CL
 OUT DX, AL
 ADD DX, 2

 IN AL, DX
 MOV [R], AL
 CMP AL, 63
 JE @@ONE
 INC [R]
 MOV BX, 1

 @@ONE:
 IN AL, DX
 MOV [G], AL
 CMP AL, 63
 JE @@TWO
 INC [G]
 MOV BX, 1

 @@TWO:
 IN AL, DX
 MOV [B], AL
 CMP AL, 63
 JE @@THREE
 INC [B]
 MOV BX, 1

 @@THREE:
 DEC DX
 MOV AL, CL
 OUT DX, AL
 INC DX
 MOV AL, [R]
 OUT DX, AL
 MOV AL, [G]
 OUT DX, AL
 MOV AL, [B]
 OUT DX, AL
 SUB DX, 2
 LOOP JUMPHERE
 MOV CX, 0FFFFh
 PAUSE1:
 LOOP PAUSE1
 TEST BX, BX
 JNZ KEEPGOING
 RET
ENDP BLOWUP


FADEOUT PROC

 KEEPGOING2:
 XOR CX, CX
 XOR BX, BX
 CALL RETRACE
 MOV DX, 03C7h
 JUMPHERE2:
 MOV AL, CL
 OUT DX, AL
 ADD DX, 2

 IN AL, DX
 MOV [R], AL
 TEST AL, AL
 JZ @@ONE1
 DEC [R]
 MOV BX, 1

 @@ONE1:
 IN AL, DX
 MOV [G], AL
 TEST AL, AL
 JZ @@TWO1
 DEC [G]
 MOV BX, 1

 @@TWO1:
 IN AL, DX
 MOV [B], AL
 TEST AL, AL
 JZ @@THREE1
 DEC [B]
 MOV BX, 1

 @@THREE1:
 DEC DX
 MOV AL, CL
 OUT DX, AL
 INC DX
 MOV AL, [R]
 OUT DX, AL
 MOV AL, [G]
 OUT DX, AL
 MOV AL, [B]
 OUT DX, AL
 SUB DX, 2
 LOOP JUMPHERE2
 MOV CX, 0FFFFh
 PAUSE2:
 LOOP PAUSE2
 TEST BX, BX
 JNZ KEEPGOING2
 RET
ENDP FADEOUT




FIRE PROC
  MOV [String], OFFSET FireWord
  MOV [String2], OFFSET FIreWord
  MOV CX, 700
  PRINTWORD:
  MOV SI, [String2]
  PUSH CX
  CALL PUTWORD
  POP CX
  MOV BL, 100
  ANIMATE2:
  DEC BL
  TEST BL, BL
  JZ SHORT PRINTWORD
  PUSH CX
  MOV SI, OFFSET DoubleBuffa
  PUSH SI
  MOV CX, 640
  ADD SI, 64000 - 640
  RANDOM:
  PUSH CX
  PUSH BX
  CALL RAND
  POP BX
  POP CX
  MOV DS:[SI], AL
  INC SI
  LOOP RANDOM
  POP SI
  MOV CX, 64000 - 320
  ADD SI, 320
  STARTLOOP:
  XOR DX, DX
  XOR AX, AX
  MOV DL, DS:[SI]
  ADD AX, DX
  MOV DL, DS:[SI + 1]
  ADD AX, DX
  MOV DL, DS:[SI - 1]
  ADD AX, DX
  MOV DL, DS:[SI + 320]
  ADD AX, DX
  SHR AX, 2
  OR AL, AL
  JZ   PLOT
  DEC AL
  PLOT:
  MOV DS:[SI - 320], AL
  INC SI
  LOOP STARTLOOP

  MOV SI, Offset DoubleBuffa
  MOV CX, 32000
  XOR DI, DI
  CALL RETRACE
  REP MOVSW
  POP CX
  LOOP ANIMATE2
  RET
ENDP FIRE

TRI PROC
 MOV CX, 700
 CRAZY:
 PUSH CX
 MOV CX, 100
 CRAPIE:
 PUSH CX
 CALL RAND

 TRI1:
 TEST AL, 1
 JZ SHORT TRI2

 TEST AH, 1
 JZ @@NEXT1
 XOR DX, DX
 XOR CX, CX
 JMP SHORT @@TRI1PLOT

 @@NEXT1:
 TEST AH, 2
 JZ @@NEXT12
 MOV DX, 320
 XOR CX, CX
 JMP SHORT @@TRI1PLOT

 @@NEXT12:
 MOV DX, 160
 MOV CX, 200

 @@TRI1PLOT:
 MOV AX, [X1]
 MOV BX, [Y1]
 CALL TRIANGLE
 MOV [X1], AX
 MOV [Y1], BX
 JMP SHORT @PLOT

 TRI2:
 TEST AL, 2
 JZ SHORT TRI3

 TEST AH, 1
 JZ @@@NEXT
 XOR DX, DX
 XOR CX, CX
 JMP SHORT @@TRI2PLOT


 @@@NEXT:
 TEST AH, 2
 JZ @@@NEXT2
 MOV DX, 160
 MOV CX, 200
 JMP SHORT @@TRI2PLOT

 @@@NEXT2:
 XOR DX, DX
 MOV CX, 200

 @@TRI2PLOT:
 MOV AX, [X2]
 MOV BX, [Y2]
 CALL TRIANGLE
 MOV [X2], AX
 MOV [Y2], BX
 JMP SHORT @PLOT

 TRI3:
 TEST AH, 1
 JZ @@NEXT
 MOV DX, 320
 XOR CX, CX
 JMP SHORT @@TRI3PLOT

 @@NEXT:
 TEST AH, 2
 JZ @@NEXT2
 MOV DX, 320
 MOV CX, 200
 JMP SHORT @@TRI3PLOT

 @@NEXT2:
 MOV DX, 160
 MOV CX, 200

 @@TRI3PLOT:
 MOV AX, [X3]
 MOV BX, [Y3]
 CALL TRIANGLE
 MOV [X3], AX
 MOV [Y3], BX

 @PLOT:
 MOV DI, Offset DoubleBuffa
 ADD DI, [X]
 MOV AX, [Y]
 MOV BX, AX
 SHL AX, 6
 SHL BX, 8
 ADD AX, BX
 ADD DI, AX

 CALL RAND
 MOV [DI], AL
 POP CX
 TEST CX, CX
 JZ @KEEPIT
 DEC CX
 JMP CRAPIE

 @KEEPIT:
 MOV SI, Offset DoubleBuffa
 MOV CX, 32000
 XOR DI, DI
 CALL RETRACE
 REP MOVSW

 POP CX
 TEST CX, CX
 JZ NEXTIE
 DEC CX
 JMP CRAZY
 NEXTIE:
 RET
ENDP TRI

TRIANGLE PROC
 ADD AX, DX
 ADD BX, CX
 SHR AX, 1
 SHR BX, 1
 MOV [X], AX
 MOV [Y], BX
 RET
ENDP TRIANGLE



SNOW PROC
 MOV DX, 3C8h
 MOV AL, 1
 OUT DX, AL
 MOV AL, 63
 INC DX
 OUT DX, AL
 OUT DX, AL
 OUT DX, AL

 MOV DX, 3C8h
 MOV AL, 255
 OUT DX, AL
 INC DX
 MOV AL, 40
 OUT DX, AL
 MOV AL, 23
 OUT DX, AL
 MOV AL, 30
 OUT DX, AL

 MOV [String], OFFSET SnowWord
 MOV [String2], OFFSET SnowWord
 MOV SI, [String]
 CALL PutWord

 MOV CX, 1000

 SNOWANIMATE:
 PUSH CX
 MOV SI, OffSet DoubleBuffa
 MOV CX, [SnowNumber]
 RANDIE:
 PUSH CX
 CALL RAND
 POP CX
 AND BH, 2h
 MOV AL, 01h
 MOV DS:[SI+BX], AL
 LOOP RANDIE
 MOV CX, 64000-319
 ADD SI, CX
 INC CX
 SNOWFALL:
 CMP BYTE PTR DS:[SI], 01h
 JNE LOOPAGAIN
 PUSH CX
 CALL RAND
 POP CX
 TEST AL, 1h
 JZ PLOTLEFT
 MOV BX, 321
 CMP BYTE PTR DS:[SI + BX], 00h
 JNE DOWN
 CALL PLOT1
 JMP SHORT LOOPAGAIN
 DOWN:
 DEC BX
 CMP BYTE PTR DS:[SI + BX], 00h
 JNE LEFT
 CALL PLOT1
 JMP SHORT LOOPAGAIN
 LEFT:
 DEC BX
 CMP BYTE PTR DS:[SI + BX], 00h
 JNE LOOPAGAIN
 CALL PLOT1
 JMP SHORT LOOPAGAIN
 PLOTLEFT:
 MOV BX, 319
 CMP BYTE PTR DS:[SI + BX], 00h
 JNE DOWN2
 CALL PLOT1
 JMP SHORT LOOPAGAIN
 DOWN2:
 INC BX
 CMP BYTE PTR DS:[SI + BX], 00h
 JNE RIGHT
 CALL PLOT1
 JMP SHORT LOOPAGAIN
 RIGHT:
 INC BX
 CMP BYTE PTR DS:[SI + BX], 00h
 JNE LOOPAGAIN
 CALL PLOT1
 LOOPAGAIN:
 DEC SI
 LOOP SNOWFALL

 MOV SI, OFFSET DoubleBuffa
 XOR DI, DI
 MOV CX, 32000
 CALL RETRACE
 REP MOVSW
 POP CX

 TEST CX, CX
 JZ ENDITALL
 DEC CX
 JMP SNOWANIMATE
 ENDITALL:
 RET
ENDP SNOW

PLOT1 PROC
 PUSH AX
 MOV AX, 1
 MOV DS:[SI], AH
 MOV DS:[SI+BX], AL
 POP AX
 RET
ENDP PLOT1


PUTWORD PROC
  PUSH SI
  BIGLOOPER:
  XOR CH, CH
  POP SI
  MOV CL, DS:[SI]
  OR CL, CL
  JNZ RUN
  MOV SI, [String]
  MOV CL, DS:[SI]
  RUN:
  INC SI
  MOV DH, 096h
  MOV DL, DS:[SI]
  INC SI
  LOOPING:
  MOV AL, DS:[SI]
  PUSH SI
  PUSH CX
  PUSH DX
  MOV DI, 0F000h
  MOV ES, DI
  MOV DI, 0FA6Eh
  MOV CL, 8
  MUL CL
  ADD DI, AX
  MOV SI, OFFSET DoubleBuffa
  ADD SI, DX
  FIRST11:
  PUSH CX
  MOV CL, 8
  MOV AL, ES:[DI]
  SECOND11:
  PUSH CX
  MOV DL, 80h
  MOV CL, 8h
  THIRD11:
  TEST AL, DL
  JZ NEXTIE11
  MOV WORD PTR DS:[SI], 0FFFFh
  MOV BYTE PTR DS:[SI + 2], 0FFh
  NEXTIE11:
  ADD SI, 3
  SHR DL, 1
  LOOP THIRD11
  POP CX
  ADD SI, 296
  LOOP SECOND11
  POP CX
  INC DI
  LOOP FIRST11
  POP DX
  POP CX
  POP SI
  INC SI
  ADD DX, 28
  LOOP LOOPING
  MOV [String2], SI
  MOV AX, 0A000h
  MOV ES, AX
  RET
ENDP PUTWORD



;-------------------
; Returns a Random
; Number In AX
;-------------------

RAND PROC
  MOV AX, [Seed1]               ; Restore Seed Numbers
  MOV BX, [Seed2]
  MOV CX, [Seed3]
  MOV DX, [Seed4]

  ADD AX, BX                    ; Perform Weird
  XCHG CL, CH                   ; Operations                
  SBB DX, AX                    ; To Insure

  ADC CL, AL
  ADC AH, BL
  ADC AX, DX

  ROR DX, CL                    ; A Good Pseudo
  ROL AX, CL
  ADC AX, CX                    ; Number

  XCHG DL, CH
  XCHG DX, BX
  XCHG CH, AL
  XCHG BL, DH

  SBB AX, CX
  ADC AX, BX

  MOV [Seed1], AX               ; Save Seed Numbers
  MOV [Seed2], BX
  MOV [Seed3], CX
  MOV [Seed4], DX

  RET                           ; Return
ENDP RAND


;----------------
; Seed Random Numbers
;    Number
; Call Once Before Using RAND
;
;----------------
Seed PROC 

 MOV AH, 02h
 INT 01Ah               ; Get Clock Timer Settings

 MOV AX, DX
 MOV BX, CX

 MOV [Seed1], AX        ; Seed 1

 XCHG AL, AH            ; Perform Some Wacky Operations
 SBB AH, AL
 ADC AX, AX
 ROR BX, CL

 MOV [Seed2], AX        ; Seed 2

 ROR AX, CL

 MOV [Seed3], AX        ; Seed 3

 MOV CX, DS             ; Get Data Segment

 ADC CX, BX             ; More Wacky Operations
 ADC AX, BX
 XCHG AH, BL
 XCHG AL, AH
 ADC AL, AH

 MOV [Seed4], AX        ; Seed 4
 RET
ENDP Seed

 ; Variables
 FireWord  db  9, 50, "_Secret's", 4, 90, "Demo", 0
 SnowWord  db 7, 70, "_SECRET", 0

 EndMsg    db "By: Toby Opferman$"

 X1    dw 0
 Y1    dw 0
 X2    dw 0
 Y2    dw 0
 X3    dw 0
 Y3    dw 0
 X     dw 0
 Y     dw 0
 SnowNumber dw 7

 DoubleBuffa db 64000 DUP(?)
 String  dw ?
 String2 dw ?
 SEED1 dw ?
 SEED2 dw ?
 SEED3 dw ?
 SEED4 dw ?
 R     db ?
 G     db ?
 B     db ?
END START
