/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Driver!
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/




#ifndef __PRIVATEDATA_H__
#define __PRIVATEDATA_H__

#include "gdt.h"
#include "idt.h"
#include "paging32.h"
#include "paging64.h"
#include "memory.h"
#include "pae32.h"

/*
 * Descriptor Table Information
 */
#pragma pack(1)
typedef struct _DESCRIPTOR_TABLE32
{
    unsigned short usDescriptorTableSize;
    unsigned int   usDescriptorTablePhysicalAddress; /* Oops, this is actually Linear Address with a base of 0!!!!!! */

} DESCRIPTOR_TABLE32, *PDESCRIPTOR_TABLE32;

#pragma pack(1)
typedef struct _ALLOCATED_DESCRIPTOR_TABLE32
{

    DESCRIPTOR_TABLE32 DescriptorTableLoadingAddress;
    PVOID pOperatingSystemAllocatedAddress;

} ALLOCATED_DESCRIPTOR_TABLE32, *PALLOCATED_DESCRIPTOR_TABLE32;


/*
 * Saved Operating System State
 */
#pragma pack(1)
typedef struct _SAVE_OS_STATE32
{                      
    unsigned int uiCR0;
    unsigned int uiCR3;
    unsigned int uiCR4;

    unsigned short uiCS;
    unsigned short uiDS;    
    unsigned short uiES;
    unsigned short uiFS;
    unsigned short uiGS;
    unsigned short uiSS;

    DESCRIPTOR_TABLE32 dt32GdtLocation;
    DESCRIPTOR_TABLE32 dt32LdtLocation;
    DESCRIPTOR_TABLE32 dt32IdtLocation;
    
} SAVE_OS_STATE32, *PSAVE_OS_STATE32;

/*
 * Operating System Descriptor Mappings
 *
 *   This structure contains the memory
 *   offsets specified in the GDT
 *   for the following supplied
 *   selectors.  This data is
 *   then used to generate our page
 *   tables
 */
#pragma pack(1)
typedef struct _OS_DESCRIPTOR_MAPPINGS
{
    unsigned int uiCSDescriptorMapping;
    PGDT_SYSTEM_DESCRIPTOR_ENTRY pCSDescriptor;

    unsigned int uiDSDescriptorMapping;
    PGDT_SYSTEM_DESCRIPTOR_ENTRY pDSDescriptor;

    unsigned int uiESDescriptorMapping;
    PGDT_SYSTEM_DESCRIPTOR_ENTRY pESDescriptor;

    unsigned int uiFSDescriptorMapping;
    PGDT_SYSTEM_DESCRIPTOR_ENTRY pFSDescriptor;

    unsigned int uiGSDescriptorMapping;
    PGDT_SYSTEM_DESCRIPTOR_ENTRY pGSDescriptor;

    unsigned int uiSSDescriptorMapping;
    PGDT_SYSTEM_DESCRIPTOR_ENTRY pSSDescriptor;

    /*
     * Define a location to hold our 
     * 64 bit Long Mode descriptor
     */
    unsigned int uiLMDescriptorMapping;

    /*
     * Need to define an identity descriptor
     * in order to switch from Pmode Paging
     * to no paging.
     */
    unsigned int uiIdentityCSDescriptorMapping;
    unsigned int uiCodePhysicalAddress;
    unsigned int uiIdentityDSDescriptorMapping;
    unsigned int uiIdentityESDescriptorMapping;
    unsigned int uiIdentityFSDescriptorMapping;
    unsigned int uiIdentityGSDescriptorMapping;
    unsigned int uiIdentitySSDescriptorMapping;
    unsigned int uiStackPhysicalAddress;

    DESCRIPTOR_TABLE32 GdtDescriptorTable;

    ALLOCATED_DESCRIPTOR_TABLE32 AllocatedDescriptorTable;
    
} OS_DESCRIPTOR_MAPPINGS, *POS_DESCRIPTOR_MAPPINGS;


/*
 * 32 Bit Paging State
 *
 *   This structure contains information
 *   relating to 32 bit paging implementation.
 */
#pragma pack(1)
typedef struct _PAGE_TABLE_MAPPING32
{
    MEMORY_BLOCK OSAllocatedMemoryBlock;

    unsigned int uiLastPageIndexAllocated;
#if 0
    PPAGETABLE_PTE_ENTRY32 ptePageDirectoryTable[1024];
#else
/*
 * To clear some stack space this should be allocated.  The code
 * is not in there to do this since I am not testing with non-PAE
 * paging.
 */
    PPAGETABLE_PTE_ENTRY32 *ptePageDirectoryTable;
#endif

    CR3_REGISTER32  CR3_32bit;

} PAGE_TABLE_MAPPING32, *PPAGE_TABLE_MAPPING32;

/*
 * 32 Bit PAE Paging State
 *
 *   This structure contains information
 *   relating to 32 bit paging implementation 
 *   using Physical Address Extensions (36 - Bit Virtual Addresses)
 */
#pragma pack(1)
typedef struct _PAGE_TABLE_PAE_MAPPING32
{
    MEMORY_BLOCK OSAllocatedMemoryBlock;

    unsigned int uiLastPageIndexAllocated;

    PPAGETABLE_PDE_ENTRY_PAE32 pdePageDirectoryPointerIndex[4];
    
    CR3_REGISTER32  CR3_32bit;

} PAGE_TABLE_PAE_MAPPING32, *PPAGE_TABLE_PAE_MAPPING32;


/*
 * 64 Bit Paging State
 *
 *   This structure contains information
 *   relating to 64 bit paging implementation.
 */
#pragma pack(1)
typedef struct _PAGE_TABLE_MAPPING64
{
    /*
     * These are not used since we did not seperate
     * 64 bit and 32 bit PAE.
     *
     * MEMORY_BLOCK OSAllocatedMemoryBlock;
     * CR3_REGISTER64  CR3_64bit; 
     */
    PPAGETABLE_PML4_ENTRY64 pPageTablePML4Entry;
    PVOID pPhysicalAddressOfPML4;

    PPAGETABLE_PDP_ENTRY_PAE32 pPageDirectoryPointerTable;
    PVOID pPhysicalAddressOfPDP;

    CR3_REGISTER32  CR3_32bit;

} PAGE_TABLE_MAPPING64, *PPAGE_TABLE_MAPPING64;


/*
 * Application Address Mapping
 *
 *   This location contains the
 *   64 bit application
 */
#pragma pack(1)
typedef struct _APPLICATION_64BIT
{
    PVOID pApplicationStack;
    PVOID pApplicationStackPhysicalAddress;

    PVOID pApplicationCode;
    PVOID pApplicationCodePhysicalAddress;

    unsigned int uiLastPageIndexAllocated;

    MEMORY_BLOCK OSAllocatedMemoryBlock;

    PVOID pOriginalApplicationCode;
    unsigned int uiSizeOfCode;

} APPLICATION_64BIT, *PAPPLICATION_64BIT;




                  

/*
 * Operating System Thunking Data Context
 *
 *   This is the single data structure that contains
 *   all the information nessecary to convert to 64-bit
 *   and to restore the host operating system.
 */
#pragma pack(1)
typedef struct _OPERATING_SYSTEM_THUNK_DATA
{
    SAVE_OS_STATE32    OsState32;
    
    ALLOCATED_DESCRIPTOR_TABLE32 dtGlobalTable;
    ALLOCATED_DESCRIPTOR_TABLE32 dtInterruptTable;
    
    OS_DESCRIPTOR_MAPPINGS OsDescriptorMapping;

    PAGE_TABLE_MAPPING64 PageTables64;
    PAGE_TABLE_PAE_MAPPING32 PAEPageTables32;
    PAGE_TABLE_MAPPING32 PageTables32;
    

    APPLICATION_64BIT Application64;

} OPERATING_SYSTEM_THUNK_DATA, *POPERATING_SYSTEM_THUNK_DATA;

#endif






