/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Implementation
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/
 
 /*
  * This code is PROTOTYPE (done in code & fix).  It looks horrible because all files are dependent
  * and the object isolation is not existant!  However the naming convention
  * I tried to keep something readable and the functions all only have 1
  * exit point.
  *
  * I do not intend to clean this up since it's just a prototype code and it would
  * take some work after it's working to go back and isolate everything properly (and actually design it).
  * Remember, if any of these data structures or anything is off by even 1 bit
  * you will blue screen or reboot your machine and then you'll have to track
  * down what's wrong!  If you reboot it's a bit harder to find ! So this code is
  * a mess but it's also not intended to be used in any product or project. I am
  * the only person testing it as well.
  *
  * The idea is a tribute to DOS Extenders with a "Windows" Extender.
  *                                                                                          
  * Also, it works on my machine!!!  AMD Athlon64 3200+ with Windows XP SP 2.
  * PAE is the only tested version since the OS would not run in normal paging
  * even with /NOPAE boot flag.  I didn't care enough to persue it further.
  *
  * There are a lot of fringe cases not taken into account!!!!!!! Such as
  * Windows not mapping Virtual Addresses Linear to Physical Addresses for
  * certain things such as "the stack" when we turn off paging for example.
  * We should switch to our own stack, actually we should be implementing a lot
  * more code however again this is just a prototype.
  *
  */
  
#define _X86_

#include <ddk\ntddk.h>
#include "privatedata.h"

/*
 * Internal Prototypes
 */
void Mutiny_SaveState(PSAVE_OS_STATE32 pOsState32);
void Mutiny_RestoreState(PSAVE_OS_STATE32 pOsState32);
NTSTATUS Mutiny_OperatingSystemSetup64(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_OperatingSystemFreeResources(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_Setup32BitPageTables(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_EnableThunkPages32(PCR3_REGISTER32 pCR3Register);
NTSTATUS Mutiny_RestoreOSPages32(unsigned int uiSavedCR3Register, unsigned int uiSavedCR4Register);
NTSTATUS Mutiny_Execute64(unsigned short usIdentityCSDescriptor, unsigned int uiCodePhysicalAddress, unsigned short usIdentitySSDescriptor, unsigned int uiStackPhysicalAddress, PDESCRIPTOR_TABLE32 pLocalDescriptorTable, PDESCRIPTOR_TABLE32 pOSDescriptorTable, PCR3_REGISTER32 pCR3Register, unsigned short usLongModeDescriptor);
NTSTATUS Mutiny_TestIdentityDescriptor(unsigned short usIdentityCSDescriptor, unsigned short usIdentitySSDescriptor, PDESCRIPTOR_TABLE32 pLocalDescriptorTable, PDESCRIPTOR_TABLE32 pOSDescriptorTable);
NTSTATUS Mutiny_Setup32BitPageTablesPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_TestPageTables32(PCR3_REGISTER32 pCR3Register);
NTSTATUS Mutiny_Disable32BitPaging(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapCodeSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapCodeSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapIdentityCodeSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapIdentityCodeSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapIdentityStackSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapLinearAddressesPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapStackAddressesPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapGDTPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapIdentityStackSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapLinearAddresses(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapStackAddresses(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_MapGDT(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_AllocateApplication(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_Map64CodeSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Mutiny_Map64CodeSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);



/**********************************************************************
 * 
 *  Mutiny_TakeOverTheOperatingSystem
 *
 *    This API cooredinates the Operating System Take Over
 *    This API will restore control back to the Operating System
 *    before it returns.
 *
 **********************************************************************/
void Mutiny_TakeOverTheOperatingSystem(PVOID pCode, unsigned int uiCodeSize)
{
    OPERATING_SYSTEM_THUNK_DATA OperatingSystemThunkState = {0};
    KIRQL kIrql;
    KFLOATING_SAVE kFloatingSave = {0};
    

    KeSaveFloatingPointState(&kFloatingSave);

    /*
     * Save the Code for copying later.
     */
    OperatingSystemThunkState.Application64.pOriginalApplicationCode = pCode;
    OperatingSystemThunkState.Application64.uiSizeOfCode             = uiCodeSize;


    /*
     * First thing we will do is stop the OS Scheduler.
     *   This will allow us to safely call APIs on MSDN
     *   while not worrying about being interrupted.
     *
     *   Once that is complete we'll disable all interrupts
     *   completely.
     */
    KeRaiseIrql(DISPATCH_LEVEL, &kIrql);


    Mutiny_SaveState(&OperatingSystemThunkState.OsState32);

    /*
     * Here is an Idea.  Before we thunk the operating system
     * let's allocate our memory, setup our tables
     * and so we are ready to go!
     */
    Mutiny_OperatingSystemSetup64(&OperatingSystemThunkState);
     
    /*
     * Is PAE Enabled?? If so we need to do make sure
     * we setup the correct paging.  BTW, All of these functions
     * that are in the path of our page tables should really have been allocated memory
     * so we could better control the page boundaries instead of playing stupid here.
     *
     */
    if((OperatingSystemThunkState.OsState32.uiCR4 & 0x20) == 0)
    {
        /*
         * Not fully supported, set boot.ini to /PAE.
         *
         */
#if 0
       /* _asm int 3*/
        _asm CLI
        
        Mutiny_EnableThunkPages32(&OperatingSystemThunkState.PageTables32.CR3_32bit);

        Mutiny_Execute64((unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentityCSDescriptorMapping, OperatingSystemThunkState.OsDescriptorMapping.uiCodePhysicalAddress, (unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentitySSDescriptorMapping, OperatingSystemThunkState.OsDescriptorMapping.uiStackPhysicalAddress, &OperatingSystemThunkState.OsDescriptorMapping.AllocatedDescriptorTable.DescriptorTableLoadingAddress, &OperatingSystemThunkState.OsState32.dt32GdtLocation, &OperatingSystemThunkState.PageTables64.CR3_32bit, (unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiLMDescriptorMapping);
#if 0
        Mutiny_TestIdentityDescriptor((unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentityCSDescriptorMapping, (unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentitySSDescriptorMapping, &OperatingSystemThunkState.OsDescriptorMapping.AllocatedDescriptorTable.DescriptorTableLoadingAddress, &OperatingSystemThunkState.OsState32.dt32GdtLocation);
#endif
        Mutiny_RestoreOSPages32(OperatingSystemThunkState.OsState32.uiCR3, OperatingSystemThunkState.OsState32.uiCR4);
        
    
#if 0
        Mutiny_TestPageTables32(&OperatingSystemThunkState.PageTables32.CR3_32bit);
#endif
    
    
    
       _asm STI
#endif
   }
   else
   {
       /*_asm int 3*/
       _asm CLI

       Mutiny_EnableThunkPages32(&OperatingSystemThunkState.PAEPageTables32.CR3_32bit);

       Mutiny_Execute64((unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentityCSDescriptorMapping, OperatingSystemThunkState.OsDescriptorMapping.uiCodePhysicalAddress, (unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentitySSDescriptorMapping, OperatingSystemThunkState.OsDescriptorMapping.uiStackPhysicalAddress, &OperatingSystemThunkState.OsDescriptorMapping.AllocatedDescriptorTable.DescriptorTableLoadingAddress, &OperatingSystemThunkState.OsState32.dt32GdtLocation, &OperatingSystemThunkState.PageTables64.CR3_32bit, (unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiLMDescriptorMapping);
#if 0
       Mutiny_TestIdentityDescriptor((unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentityCSDescriptorMapping, (unsigned short)OperatingSystemThunkState.OsDescriptorMapping.uiIdentitySSDescriptorMapping, &OperatingSystemThunkState.OsDescriptorMapping.AllocatedDescriptorTable.DescriptorTableLoadingAddress, &OperatingSystemThunkState.OsState32.dt32GdtLocation);
#endif
       Mutiny_RestoreOSPages32(OperatingSystemThunkState.OsState32.uiCR3, OperatingSystemThunkState.OsState32.uiCR4);


#if 0
       Mutiny_TestPageTables32(&OperatingSystemThunkState.PAEPageTables32.CR3_32bit);
#endif


      _asm STI
   }


   Mutiny_OperatingSystemFreeResources(&OperatingSystemThunkState);

   KeLowerIrql(kIrql);

   KeRestoreFloatingPointState(&kFloatingSave);
}


/**********************************************************************
 * 
 *  Mutiny_EnableThunkPages32
 *
 *   This API will be used to help thunk the OS page tables. 
 *
 **********************************************************************/
__declspec (naked) NTSTATUS Mutiny_EnableThunkPages32(PCR3_REGISTER32 pCR3Register)
{
    _asm {
           ; MOV EAX, CR4                     ; Save CR4 State
           ;                                   The compiler does not recognize CR4. 
           __emit 0fh
           __emit 20h
           __emit 0e0h
           
           AND EAX, 0FFFFFF7Fh
     ;      
     ;      ; MOV CR4, EAX  The compiler does not recognize CR4. 
           __emit 0fh
           __emit 22h
           __emit 0e0h            
            
            MOV EAX, [ESP + 4]                      ; The CR3 Register Pointer
            
            MOV EAX, [EAX]                          ; The CR3 Register Data

            MOV CR3, EAX                            ; Populate the new CR3
            
                                                    ; Flush Internal Caches
            
            RET 4
    }
}




/**********************************************************************
 * 
 *  Mutiny_RestoreOSPages32
 *
 *   This API will be used to restore the page tables. 
 *
 **********************************************************************/
__declspec (naked) NTSTATUS Mutiny_RestoreOSPages32(unsigned int uiSavedCR3Register, unsigned int uiSavedCR4Register)
{
    _asm {
                      ;                      ; Restore CR4 State
           ;                                   The compiler does not recognize CR4. 
         ;  __emit 0fh
         ;  __emit 20h
         ;  __emit 0e0h
           
           MOV EAX, [ESP + 8]
         ;  OR EAX, 80h     
           ; MOV CR4, EAX  The compiler does not recognize CR4. 
           __emit 0fh
           __emit 22h
           __emit 0e0h
            
            MOV EAX, [ESP + 4]                      ; The Saved CR3 Register 
            
            MOV CR3, EAX                            ; Populate the new CR3
            
            RET 8
    }
}


/**********************************************************************
 * 
 *  Mutiny_TestPageTables32
 *
 *    This will help do smoke testing on our page tables.
 *
 **********************************************************************/
__declspec (naked) NTSTATUS Mutiny_TestPageTables32(PCR3_REGISTER32 pCR3Register)
{
    _asm {
    
            PUSH EBP
            MOV EBP, ESP
            PUSH EBX
            
            MOV EAX, [EBP + 8]                      ; The CR3 Register Pointer
            
            MOV EAX, [EAX]                          ; The CR3 Register Data
            MOV EBX, CR3                            ; Save the old CR3
            MOV CR3, EAX                            ; Populate the new CR3
            
            ;INVLPG
            
            XOR EAX, EAX                            ; Some smoke test, even though the
                                                    ;      MOV CR3, EAX would have trapped anyway
            MOV CR3, EBX                            ; Restorethe original CR3
            
            ;INVLPG
            
            XOR EAX, EAX
            POP EBX
            POP EBP
            
            RET 4

    }
}

/**********************************************************************
 * 
 *  Mutiny_OperatingSystemSetup64
 *
 *    This API will setup the data required to thunk the
 *    operating system.
 *
 **********************************************************************/
NTSTATUS Mutiny_OperatingSystemSetup64(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS  NtStatus = STATUS_SUCCESS;
   
    GDT_Setup64BitGlobalDescriptorTable(pOperatingSystemThunkState);
    IDT_Setup64BitInterruptDescriptorTable(pOperatingSystemThunkState);
    Mutiny_AllocateApplication(pOperatingSystemThunkState);

    /*
     * Is PAE Enabled?? If so we need to do make sure
     * we setup the correct paging
     *
     */
    if((pOperatingSystemThunkState->OsState32.uiCR4 & 0x20) == 0)
    {
        /*
         * Not Fully Supported, Change your BOOT.INI to /PAE
         */
#if 0
        Mutiny_Setup32BitPageTables(pOperatingSystemThunkState);
#endif       
    }
  
    /*
     * 64 bit and 32 bit PAE Overlap.  So, to eliminate duplication
     * of code, create the 32 bit PAE tables and then point the
     * 64 bit PML4 at what we created.  
     *
     */                      
    Mutiny_Setup32BitPageTablesPAE(pOperatingSystemThunkState);
    Paging64_Map32BitPaeTo64BitPML4(pOperatingSystemThunkState);

    // Mutiny_Setup64BitCodeSegment(pOperatingSystemThunkState);
   // Mutiny_Setup64BitPageTables(pOperatingSystemThunkState);
    return NtStatus;
}


/**********************************************************************
 * 
 *  Mutiny_Execute64
 *
 *    This API will disable paging, do a double jump and go to 64 bit mode.
 *
 *  BTW, for a real solution this should be an allocated buffer. Actually
 *  most everything during the page switching should be so that the identity
 *  mappings do not cross page boundaries which may be non-linear!!!!
 *
 *  I just didn't feel like making it that complex yet, just get it working first.
 *
 **********************************************************************/
__declspec (naked)  NTSTATUS Mutiny_Execute64(unsigned short usIdentityCSDescriptor, unsigned int uiCodePhysicalAddress, unsigned short usIdentitySSDescriptor, unsigned int uiStackPhysicalAddress, PDESCRIPTOR_TABLE32 pLocalDescriptorTable, PDESCRIPTOR_TABLE32 pOSDescriptorTable, PCR3_REGISTER32 pCR3Register, unsigned short usLongModeDescriptor)
{
    _asm {
            PUSH EBP                       ; CS Selector   = 08h
            MOV EBP, ESP                   ; CodePhysical  = 0ch
                                           ; SS Selector   = 10h
            PUSH EBX                       ; StackPhysical = 14h
            PUSH ECX                       ; OurGDT        = 18h
            PUSH EDX                       ; OSGDT         = 1Ch
            PUSH ESI                       ; 64 CR3        = 20h
            PUSH EDI                       ; LM Selector   = 24h
            
            
            MOV EAX, [EBP + 18h]                    
            LGDT FWORD PTR [EAX]                    ; Our mapped GDT
            
            
            MOV EAX, OFFSET Mutiny_JumpToIdentityDescriptor
            MOV EBX, [EBP + 0Ch]
            AND EAX, 0FFFh
            AND EBX, 0FFFFF000h
            MOV ESI, EBX
            OR  EBX, EAX                            ; Create a Physical Address Mapping to Jump
            
            MOV EAX, OFFSET Mutiny_SwitchBackTo32Bit
            AND EAX, 0FFFh
            OR  ESI, EAX                            ; Create a Physical Address Mapping to Jump Back From 64 Bit

                        
            MOV EAX, [EBP + 08h]                    ; Identity Code Segment
            
            PUSH CS
            PUSH OFFSET  Mutiny_JumpBackFromIdentityDescriptor
                                                                     
            PUSH EAX
            PUSH EBX                                             
            RETF

    }
    Mutiny_JumpToIdentityDescriptor:

    _asm {
            
            MOV EBX, [EBP + 20h]
            MOV EBX, [EBX]                                ; Get the 64 bit CR3 in EBX
            
            MOV ECX, [EBP + 14h]                          ; New Stack Offset
                                                          ; Put the new stack ESP
            MOV EDI, ESP                                  ; Save the Old Stack ESP
            MOV ESP, ECX                                                          
            
            MOV ECX, [EBP + 24h]                          ; Long Mode Selector
            
            MOV EAX, [EBP + 10h]                          ; New Stack Selector
            MOV DX, SS
            MOV SS, AX                                    ; Set New Selector
            
            PUSH EDX                                      ; We make no assumptions that New SS == Old SS.
            PUSH EDI                                      ; Save Old Stack ESP.
            
            MOV EDI, ECX                                  ; Swap Long Mode Selector
            
            MOV EAX, CR0                                  ; Disable Paging
            AND EAX, 07FFFFFFFh                          
            MOV CR0, EAX
            
            ;
            ; Setup 64 Bit Here
            ;
            
     ;      __emit 0fh
     ;      __emit 20h
     ;      __emit 0e0h                                   ; MOV EAX, CR4
           
     ;      PUSH EAX                                      ; Save CR4
            
     ;      OR EAX, 20h     
      ;     ; MOV CR4, EAX  The compiler does not recognize CR4. 
     ;      __emit 0fh
     ;      __emit 22h
     ;      __emit 0e0h                                   ; Make Sure PAE is enabled.
            
            MOV EAX, CR3
            PUSH EAX                                    ; Save Old Page Tables
            
            
             
           
            MOV EAX, EBX
            MOV CR3, EAX                                 ; Set the 64 bit Page Table Entries
   
            MOV ECX, 0C0000080h                          ; These are to read Model Specific Registers
            RDMSR                                        ; based on the number in ECX.
                                                         ; This number is for the EFER Register.
                                                         ; "Extended Features Enable Register"
        
            OR EAX, 100h                                 ; Bit 8 == LONG MODE
            WRMSR                                        ; Write the value back to the register.


            MOV EAX, CR0                                 ; Paging Must now be activiated to enable
            OR EAX, 080000000h                           ; LONG MODE
            MOV CR0, EAX
            
            ; We are in compatiblity mode (32 bit here) so now we will need to jump to
            ; a 64 bit code segment.
         
            PUSH CS
            PUSH ESI                                     ; Return Location  Mutiny_SwitchBackTo32Bit
            
            PUSH EDI                                     ; 64 Bit Code
            PUSH 0
            RETF
    }
    Mutiny_SwitchBackTo32Bit:
    _asm {
            ;
            ; Switch Back to 32 Bit
            ;
            MOV EAX, CR0                                  ; Disable Paging
            AND EAX, 07FFFFFFFh                          
            MOV CR0, EAX

                        
            MOV ECX, 0C0000080h                          ; These are to read Model Specific Registers
            RDMSR                                        ; based on the number in ECX.
                                                         ; This number is for the EFER Register.
                                                         ; "Extended Features Enable Register"
        
            AND EAX, 0FFFFFEFFh                          ; Bit 8 == LONG MODE, Remove This
            WRMSR                                        ; Write the value back to the register.
            
            
            ;
            ; Restore Code
            ;
            
     ;      POP EAX
     ;      __emit 00fh
     ;      __emit 22h
     ;      __emit 0e0h                                   ; Restore CR4            
            
            POP EAX
            MOV CR3, EAX                                 ; Restore CR3
            
             
            MOV EAX, CR0                                 ; Re-Enable Paging
            OR EAX, 080000000h
            MOV CR0, EAX
            
            POP EBX
            POP EDX                                      ; Restore Old Stack
            
            MOV ESP, EBX
            MOV SS, DX
            
            RETF
    }
    Mutiny_JumpBackFromIdentityDescriptor:
    _asm {
    
             
            MOV EAX, [EBP + 01Ch] 
            LGDT FWORD PTR [EAX]

            
            POP EDI
            POP ESI
            POP EDX
            POP ECX
            POP EBX
            
            XOR EAX, EAX
            
            POP EBP
            RET 020h
            
    }
}


/**********************************************************************
 * 
 *  Mutiny_TestIdentityDescriptors
 *
 *    This API will test the Identity descriptors to ensure
 *    they are behaving correctly.
 *
 **********************************************************************/
__declspec (naked)  NTSTATUS Mutiny_TestIdentityDescriptor(unsigned short usIdentityCSDescriptor, unsigned short usIdentitySSDescriptor, PDESCRIPTOR_TABLE32 pLocalDescriptorTable, PDESCRIPTOR_TABLE32 pOSDescriptorTable)
{
    _asm {
            PUSH EBP
            MOV EBP, ESP
            
            PUSH ECX
            
            MOV EAX, [EBP + 10h]
            LGDT FWORD PTR [EAX]
            
            MOV EAX, [EBP + 08h] 
            
            PUSH CS
            PUSH OFFSET Mutiny_JumpBackFromIdentityDescritpor
                                                                     
            PUSH EAX
            PUSH OFFSET Mutiny_JumpToIdentityDescritpor                                             
            RETF

    }
    Mutiny_JumpToIdentityDescritpor:

    _asm {
            
            MOV EAX, CR0                                  ; Disable Paging
            AND EAX, 07FFFFFFFh                          
            MOV CR0, EAX
            
            MOV EDI, 0A0000h
            XOR EAX, EAX
            MOV ECX, 600*50
            REP STOSD                                    ; The test to show we are in non-paged mode, writes black
                                                         ; to the top of the console screen.
                                                         

   
            MOV EAX, CR0                                 ; Re-Enable Paging
            OR EAX, 080000000h
            MOV CR0, EAX
            
            RETF
    }
    Mutiny_JumpBackFromIdentityDescritpor:
    _asm {
    
            MOV EAX, [EBP + 014h] 
            LGDT FWORD PTR [EAX]

            POP ECX
            XOR EAX, EAX
            
            POP EBP
            RET 010h
            
    }
}

/*
 * Page Table Map
 *
 *     This Array of pages are mapped to the code segment.
 */
PVOID g_pMapPageTablesToCodeSegment[] =
{
    Mutiny_TakeOverTheOperatingSystem,
    Mutiny_TestIdentityDescriptor,
    Mutiny_EnableThunkPages32,
    Mutiny_RestoreOSPages32,
    Mutiny_TestPageTables32,
    ((unsigned char *)Mutiny_TakeOverTheOperatingSystem) + 4096,
    ((unsigned char *)Mutiny_TestIdentityDescriptor) + 4096,
    ((unsigned char *)Mutiny_EnableThunkPages32) + 4096,
    ((unsigned char *)Mutiny_RestoreOSPages32) + 4096,
    ((unsigned char *)Mutiny_TestPageTables32) + 4096,

    NULL  /* List Terminator */
};


/*
 * Identity Page Table Map
 *
 *     This Array of pages are mapped to the code segment.
 */
PVOID g_pMapPageTablesToCodeSegmentAsIdentity[] =
{
    Mutiny_TakeOverTheOperatingSystem,
    Mutiny_TestIdentityDescriptor,
    Mutiny_EnableThunkPages32,
    Mutiny_RestoreOSPages32,
    Mutiny_TestPageTables32,
    ((unsigned char *)Mutiny_TakeOverTheOperatingSystem) + 4096,
    ((unsigned char *)Mutiny_TestIdentityDescriptor) + 4096,
    ((unsigned char *)Mutiny_EnableThunkPages32) + 4096,
    ((unsigned char *)Mutiny_RestoreOSPages32) + 4096,
    ((unsigned char *)Mutiny_TestPageTables32) + 4096,
    NULL  /* List Terminator */
};

/*
 * Linear Page Table Map
 *
 *     This is an array of pages to be mapped as linear (0 base)
 */
PVOID g_pMapPageTablesAsLinearAddress[] =
{

    NULL  /* List Terminator */
};




/**********************************************************************
 * 
 *  Mutiny_Setup32BitPageTablesPAE
 *
 *    This API will setup 32 bit page tables on a PAE OS.
 * 
 * Ensure that some functions are on our physical address
 *
 *   NOTE:  This actually sucks because we aren't verifying that the full
 *          function length is actually in the page table!  Luckily
 *          our functions are small and since we are going to map a
 *          few hopefully we won't get burned!!!  However this is a
 *          future "todo" to ensure that we don't take shortcuts.
 *          (This goes for all our page table mappings!) 
 *
 *          Also, some of these mappings will fail because they will
 *          be already mapped!  We are doing extremely simplistic
 *          memory management here.
 *
 *
 *
 **********************************************************************/
NTSTATUS Mutiny_Setup32BitPageTablesPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;

    /*
     * 1. Create the Page Tables
     *
     */
    PhysicalAddressExtensions32_CreatePageTables(pOperatingSystemThunkState);

    /*
     * 2. Map the code segments
     */
    Mutiny_MapCodeSegmentsPAE(pOperatingSystemThunkState);



    /*
     * 3. Map the identity descriptors & pages
     */
    Mutiny_MapIdentityCodeSegmentsPAE(pOperatingSystemThunkState);
    Mutiny_MapIdentityStackSegmentsPAE(pOperatingSystemThunkState);
 
    /*
     * 4. Map the linear addresses
     */
    Mutiny_MapLinearAddressesPAE(pOperatingSystemThunkState);
   

    /* 
     * 5. Map the stack using random addresses!
     */
    Mutiny_MapStackAddressesPAE(pOperatingSystemThunkState);


    /* 
     * 6. Map our 64 bit code segment
     */
    Mutiny_Map64CodeSegmentsPAE(pOperatingSystemThunkState);

    /* 
     * 7. Map the current GDT
     */
    Mutiny_MapGDTPAE(pOperatingSystemThunkState);

    return NtStatus;
}
    

/**********************************************************************
 * 
 *  Mutiny_MapGDTPAE
 *
 *    This API will setup 32 bit PAE page tables for GDT addressing
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapGDTPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;

    DbgPrint("**************** Mapping GDT Addresses for PAE **************************\n");

    PhysicalAddress = MmGetPhysicalAddress((PVOID)pOperatingSystemThunkState->OsState32.dt32GdtLocation.usDescriptorTablePhysicalAddress);
    
    if(PhysicalAddress.QuadPart)
    {
        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)pOperatingSystemThunkState->OsState32.dt32GdtLocation.usDescriptorTablePhysicalAddress, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped GDT Virtual Address %0x to (Physical %0x)\n\n", pOperatingSystemThunkState->OsState32.dt32GdtLocation.usDescriptorTablePhysicalAddress, (unsigned int)PhysicalAddress.QuadPart);
    }

    GDT_CreateCopyOfDescriptorTable(pOperatingSystemThunkState);

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState->OsDescriptorMapping.AllocatedDescriptorTable.pOperatingSystemAllocatedAddress);
    if(PhysicalAddress.QuadPart)
    {
        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)pOperatingSystemThunkState->OsDescriptorMapping.AllocatedDescriptorTable.pOperatingSystemAllocatedAddress, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Linear Virtual Address %0x to (Physical %0x)\n\n", pOperatingSystemThunkState->OsDescriptorMapping.AllocatedDescriptorTable.pOperatingSystemAllocatedAddress,  (unsigned int)PhysicalAddress.QuadPart);
    }

    return NtStatus;
}

/**********************************************************************
 * 
 *  Mutiny_MapStackAddressesPAE
 *
 *    This API will setup 32 bit PAE page tables for stack addressing
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapStackAddressesPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;

    DbgPrint("**************** Mapping Stack Addresses for PAE **************************\n");

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState);
    
    if(PhysicalAddress.QuadPart)
    {
        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Stack Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState,  pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
    }

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState + 4096);

    if(PhysicalAddress.QuadPart)
    {
        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)pOperatingSystemThunkState + 4096, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Stack Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState + 4096,  pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
    }

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState - 4096);

    if(PhysicalAddress.QuadPart)
    {
        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)pOperatingSystemThunkState - 4096, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Stack Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState - 4096,  pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
    }
    return  NtStatus;

}

/**********************************************************************
 * 
 *  Mutiny_MapLinearAddressesPAE
 *
 *    This API will setup 32 bit PAE page tables for linear addressing
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapLinearAddressesPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    unsigned int uiIndex = 0;

    DbgPrint("**************** Mapping Linear Addresses for PAE **************************\n");


    uiIndex = 0;
    while(g_pMapPageTablesAsLinearAddress[uiIndex] != NULL)
    {
        PhysicalAddress = MmGetPhysicalAddress(g_pMapPageTablesAsLinearAddress[uiIndex]);
        if(PhysicalAddress.QuadPart)
        {
            PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)g_pMapPageTablesAsLinearAddress[uiIndex], (unsigned int)PhysicalAddress.QuadPart);
            DbgPrint("Mapped Linear Virtual Address %0x to (Physical %0x)\n\n", g_pMapPageTablesAsLinearAddress[uiIndex],  (unsigned int)PhysicalAddress.QuadPart);
        }
        uiIndex++;
    }

    uiIndex = 0;

  /*  for(uiIndex = 0; uiIndex < 800*600*4; uiIndex+=4096)*/
    {
        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)0xA0000 + uiIndex, (unsigned int)0xA0000 + uiIndex);
    }
    /*
     * My Video Driver has memory @ d8000000
     */

    for(uiIndex = 0; uiIndex < 0x500000; uiIndex+=4096)
    {
        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)0xd8000000 + uiIndex, (unsigned int)0xd8000000 + uiIndex);
    }

     

    PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)0xB8000, (unsigned int)0xB8000);

    return  NtStatus;
}

/**********************************************************************
 * 
 *  Mutiny_MapCodeSegmentsPAE
 *
 *    This API will setup 32 bit PAE page tables for code
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapCodeSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    unsigned int uiIndex = 0;
    
    DbgPrint("**************** Mapping Code Segments for PAE **************************\n");

    while(g_pMapPageTablesToCodeSegment[uiIndex] != NULL)
    {
        PhysicalAddress = MmGetPhysicalAddress(g_pMapPageTablesToCodeSegment[uiIndex]);

        if(PhysicalAddress.QuadPart)
        {
            PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiCSDescriptorMapping, (unsigned int)g_pMapPageTablesToCodeSegment[uiIndex], (unsigned int)PhysicalAddress.QuadPart);

            DbgPrint("Mapped Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", g_pMapPageTablesToCodeSegment[uiIndex],  pOperatingSystemThunkState->OsDescriptorMapping.uiCSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
        }

        uiIndex++;
    }
    return  NtStatus;

}


/**********************************************************************
 * 
 *  Mutiny_MapIdentityCodeSegmentsPAE
 *
 *    This API will setup 32 bit Identity PAE page tables for code
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapIdentityCodeSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    int uiIdentityOffset = 0, uiIdentityDescriptorOffset = 0;
    unsigned int uiIndex = 0, uiIdentityDescriptor;

    uiIndex = 0;
    DbgPrint("**************** Mapping Identity Code Segments for PAE **************************\n");

    while(g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex] != NULL)
    {
        PhysicalAddress = MmGetPhysicalAddress(g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex]);

        if(PhysicalAddress.QuadPart)
        {
            uiIdentityDescriptorOffset = 0;/*((int)PhysicalAddress.QuadPart) - ((int)g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex]);*/
            uiIdentityOffset = (unsigned int)(PhysicalAddress.QuadPart); 

            uiIdentityDescriptor = GDT_CreateCodeIdentityDescriptor(pOperatingSystemThunkState, 0);
            
            if(uiIndex == 1)
            {
                pOperatingSystemThunkState->OsDescriptorMapping.uiIdentityCSDescriptorMapping = uiIdentityDescriptor;
                pOperatingSystemThunkState->OsDescriptorMapping.uiCodePhysicalAddress         = (unsigned int)(((unsigned int)PhysicalAddress.QuadPart)&0xFFFFFF000);
            }

            PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)uiIdentityOffset, (unsigned int)PhysicalAddress.QuadPart);
            DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Virtual %0x, Physical %0x)\n\n", g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex],  uiIdentityDescriptor, uiIdentityDescriptorOffset, uiIdentityOffset, (unsigned int)PhysicalAddress.QuadPart);
        }

        uiIndex++;                                                       
    }

    return  NtStatus;
}

/**********************************************************************
 * 
 *  Mutiny_AllocateApplication
 *
 *    Allocate The 64 Bit Application                                                
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_AllocateApplication(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;

    NtStatus = Memory_AllocateNonPaged4kPhysicallyAligned(2, &pOperatingSystemThunkState->Application64.OSAllocatedMemoryBlock);

    if(NT_SUCCESS(NtStatus))
    {
        pOperatingSystemThunkState->Application64.uiLastPageIndexAllocated++;

        pOperatingSystemThunkState->Application64.pApplicationCodePhysicalAddress = (PVOID)((unsigned char *)pOperatingSystemThunkState->Application64.OSAllocatedMemoryBlock.Aligned4kPhysicalAddress + (pOperatingSystemThunkState->Application64.uiLastPageIndexAllocated<<12));
        pOperatingSystemThunkState->Application64.pApplicationCode                = (PVOID)((unsigned char *)pOperatingSystemThunkState->Application64.OSAllocatedMemoryBlock.pVirtualMappingOf4kPhysicalAddress + (pOperatingSystemThunkState->Application64.uiLastPageIndexAllocated<<12));

        /*
         * The stack grows down so put it right before the code and we have basically 4k of stack space.
         */

        pOperatingSystemThunkState->Application64.pApplicationStack                = (PVOID)((unsigned char *)pOperatingSystemThunkState->Application64.pApplicationCode - 0x10);
        pOperatingSystemThunkState->Application64.pApplicationStackPhysicalAddress = (PVOID)((unsigned char *)pOperatingSystemThunkState->Application64.pApplicationCodePhysicalAddress - 0x10);
        
    }

    return NtStatus;
}


/**********************************************************************
 * 
 *  Mutiny_MapIdentityStackSegmentsPAE
 *
 *    This API will setup 32 bit Identity PAE page tables for stack
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapIdentityStackSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    int uiIdentityOffset = 0, uiIdentityDescriptorOffset = 0;
    unsigned int uiIndex = 0, uiIdentityDescriptor;

    DbgPrint("**************** Mapping Identity Stack Segments for PAE **************************\n");
    
    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState->Application64.pApplicationStack);

    if(PhysicalAddress.QuadPart)
    {
        uiIdentityDescriptorOffset = 0;
        uiIdentityDescriptor = GDT_CreateDataIdentityDescriptor(pOperatingSystemThunkState, uiIdentityDescriptorOffset);
        
        pOperatingSystemThunkState->OsDescriptorMapping.uiIdentitySSDescriptorMapping  = uiIdentityDescriptor;
        pOperatingSystemThunkState->OsDescriptorMapping.uiStackPhysicalAddress         = (unsigned int)PhysicalAddress.QuadPart;
        DbgPrint("  The 64 bit stack %0x:%0x\n ", pOperatingSystemThunkState->OsDescriptorMapping.uiIdentitySSDescriptorMapping, pOperatingSystemThunkState->OsDescriptorMapping.uiStackPhysicalAddress);

        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Virtual Address %0x, Physical %0x)\n\n", pOperatingSystemThunkState->Application64.pApplicationStack,  uiIdentityDescriptor, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart, (unsigned int)PhysicalAddress.QuadPart);
    }
  /*  
    if(PhysicalAddress.QuadPart)
    {
        uiIdentityDescriptorOffset = ((int)PhysicalAddress.QuadPart) - ((int)pOperatingSystemThunkState);
        uiIdentityDescriptor = GDT_CreateDataIdentityDescriptor(pOperatingSystemThunkState, uiIdentityDescriptorOffset);
        
        pOperatingSystemThunkState->OsDescriptorMapping.uiIdentitySSDescriptorMapping  = uiIdentityDescriptor;

        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState,  uiIdentityDescriptor, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart);
    }

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState + 4096);
    
    if(PhysicalAddress.QuadPart)
    {
        uiIdentityDescriptorOffset = ((int)PhysicalAddress.QuadPart) - ((int)pOperatingSystemThunkState + 4096);
        uiIdentityDescriptor = GDT_CreateCodeIdentityDescriptor(pOperatingSystemThunkState, uiIdentityDescriptorOffset);

        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState + 4096,  uiIdentityDescriptor, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart);
    }    
    
    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState - 4096);

    if(PhysicalAddress.QuadPart)
    {
        uiIdentityDescriptorOffset = ((int)PhysicalAddress.QuadPart) - ((int)pOperatingSystemThunkState - 4096);
        uiIdentityDescriptor = GDT_CreateDataIdentityDescriptor(pOperatingSystemThunkState, uiIdentityDescriptorOffset);
        
        pOperatingSystemThunkState->OsDescriptorMapping.uiIdentitySSDescriptorMapping  = uiIdentityDescriptor;

        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState - 4096,  uiIdentityDescriptor, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart);
    }    */

    return  NtStatus;
}



/**********************************************************************
 * 
 *  Mutiny_Map64CodeSegmentsPAE
 *                            
 *    This API will setup 32 bit PAE page tables for code
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_Map64CodeSegmentsPAE(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    unsigned int uiCodeAddress = 0;

    DbgPrint("**************** Mapping Code  Segments for PAE **************************\n");

    /*
     * Initialize to RETF!
     */
    *((unsigned char *)pOperatingSystemThunkState->Application64.pApplicationCode) = 0xcb;

    memcpy(pOperatingSystemThunkState->Application64.pApplicationCode, pOperatingSystemThunkState->Application64.pOriginalApplicationCode, pOperatingSystemThunkState->Application64.uiSizeOfCode); 
    
    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState->Application64.pApplicationCode);

    if(PhysicalAddress.QuadPart)
    {
        DbgPrint("  The 64 bit code %0x:%0x\n ", pOperatingSystemThunkState->OsDescriptorMapping.uiLMDescriptorMapping, pOperatingSystemThunkState->OsDescriptorMapping.uiStackPhysicalAddress);

        PhysicalAddressExtensions32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)uiCodeAddress, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Virtual Address %0x, Physical %0x)\n\n", uiCodeAddress,  pOperatingSystemThunkState->OsDescriptorMapping.uiLMDescriptorMapping, 0, (unsigned int)uiCodeAddress, (unsigned int)PhysicalAddress.QuadPart);
    }

    return  NtStatus;
}


/**********************************************************************
 * 
 *  Mutiny_Map64CodeSegments
 *                            
 *    This API will setup 32 bit PAE page tables for code
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_Map64CodeSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    unsigned int uiCodeAddress = 0;

    DbgPrint("**************** Mapping  Code Segments for 32 bit **************************\n");
    
    /*
     * Initialize to RETF!
     */
    *((unsigned char *)pOperatingSystemThunkState->Application64.pApplicationCode) = 0xcb;

    memcpy(pOperatingSystemThunkState->Application64.pApplicationCode, pOperatingSystemThunkState->Application64.pOriginalApplicationCode, pOperatingSystemThunkState->Application64.uiSizeOfCode); 

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState->Application64.pApplicationCode);

    if(PhysicalAddress.QuadPart)
    {
         
        DbgPrint("  The 64 bit code %0x:%0x\n ", pOperatingSystemThunkState->OsDescriptorMapping.uiLMDescriptorMapping, pOperatingSystemThunkState->OsDescriptorMapping.uiStackPhysicalAddress);

        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)uiCodeAddress, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Virtual Address %0x, Physical %0x)\n\n", uiCodeAddress,  pOperatingSystemThunkState->OsDescriptorMapping.uiLMDescriptorMapping, 0, (unsigned int)uiCodeAddress, (unsigned int)PhysicalAddress.QuadPart);
    }

    return  NtStatus;
}











/**********************************************************************
 * 
 *  Mutiny_Setup32BitPageTables
 *
 *    This API will setup 32 bit page tables.
 * 
 * Ensure that some functions are on our physical address
 *
 *   NOTE:  This actually sucks because we aren't verifying that the full
 *          function length is actually in the page table!  Luckily
 *          our functions are small and since we are going to map a
 *          few hopefully we won't get burned!!!  However this is a
 *          future "todo" to ensure that we don't take shortcuts.
 *          (This goes for all our page table mappings!) 
 *
 *          Also, some of these mappings will fail because they will
 *          be already mapped!  We are doing extremely simplistic
 *          memory management here.
 *
 *
 *
 **********************************************************************/
NTSTATUS Mutiny_Setup32BitPageTables(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;

    /*
     * 1. Create the Page Tables
     *
     */
    Paging32_CreatePageTables(pOperatingSystemThunkState);

    /*
     * 2. Map the code segments
     */
    Mutiny_MapCodeSegments(pOperatingSystemThunkState);                                                   

    /*
     * 3. Map the identity descriptors & pages
     */
    Mutiny_MapIdentityCodeSegments(pOperatingSystemThunkState);
    Mutiny_MapIdentityStackSegments(pOperatingSystemThunkState);
 
    /*
     * 4. Map the linear addresses
     */
    Mutiny_MapLinearAddresses(pOperatingSystemThunkState);
   

    /* 
     * 5. Map the stack using random addresses!
     */
    Mutiny_MapStackAddresses(pOperatingSystemThunkState);

    /* 
     * 6. Map our 64 bit code segment
     */
    Mutiny_Map64CodeSegments(pOperatingSystemThunkState);


    /* 
     * 7. Map the current GDT
     */
    Mutiny_MapGDT(pOperatingSystemThunkState);


    return NtStatus;
}

/**********************************************************************
 * 
 *  Mutiny_MapCodeSegments
 *
 *    This API will setup 32 bit  page tables for code
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapCodeSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    unsigned int uiIndex = 0;
    
    DbgPrint("**************** Mapping Code Segments for 32 Bit **************************\n");

    uiIndex = 0;
    while(g_pMapPageTablesToCodeSegment[uiIndex] != NULL)
    {
        PhysicalAddress = MmGetPhysicalAddress(g_pMapPageTablesToCodeSegment[uiIndex]);
        if(PhysicalAddress.QuadPart)
        {
        
            Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiCSDescriptorMapping, (unsigned int)g_pMapPageTablesToCodeSegment[uiIndex], (unsigned int)PhysicalAddress.QuadPart);
            DbgPrint("Mapped Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", g_pMapPageTablesToCodeSegment[uiIndex],  pOperatingSystemThunkState->OsDescriptorMapping.uiCSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
        }

        uiIndex++;
    }
    return  NtStatus;

}


/**********************************************************************
 * 
 *  Mutiny_MapGDT
 *
 *    This API will setup 32 bit  page tables for GDT addressing
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapGDT(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;

    DbgPrint("**************** Mapping GDT Addresses for 32 bit **************************\n");

    PhysicalAddress = MmGetPhysicalAddress((PVOID)pOperatingSystemThunkState->OsState32.dt32GdtLocation.usDescriptorTablePhysicalAddress);
    
    if(PhysicalAddress.QuadPart)
    {
        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)pOperatingSystemThunkState->OsState32.dt32GdtLocation.usDescriptorTablePhysicalAddress, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped GDT Virtual Address %0x to (Physical %0x)\n\n", pOperatingSystemThunkState->OsState32.dt32GdtLocation.usDescriptorTablePhysicalAddress, (unsigned int)PhysicalAddress.QuadPart);
    }

    GDT_CreateCopyOfDescriptorTable(pOperatingSystemThunkState);

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState->OsDescriptorMapping.AllocatedDescriptorTable.pOperatingSystemAllocatedAddress);
    if(PhysicalAddress.QuadPart)
    {
        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)pOperatingSystemThunkState->OsDescriptorMapping.AllocatedDescriptorTable.pOperatingSystemAllocatedAddress, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Linear Virtual Address %0x to (Physical %0x)\n\n", pOperatingSystemThunkState->OsDescriptorMapping.AllocatedDescriptorTable.pOperatingSystemAllocatedAddress,  (unsigned int)PhysicalAddress.QuadPart);
    }

    return NtStatus;
}

/**********************************************************************
 * 
 *  Mutiny_MapStackAddresses
 *
 *    This API will setup 32 bit  page tables for stack addressing
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapStackAddresses(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;

    DbgPrint("**************** Mapping Stack Addresses for 32 bit **************************\n");

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState);
    
    if(PhysicalAddress.QuadPart)
    {
        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Stack Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState,  pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
    }

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState + 4096);

    if(PhysicalAddress.QuadPart)
    {
        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)pOperatingSystemThunkState + 4096, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Stack Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState + 4096,  pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
    }

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState - 4096);

    if(PhysicalAddress.QuadPart)
    {
        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)pOperatingSystemThunkState - 4096, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Stack Virtual Address %0x to (Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState - 4096,  pOperatingSystemThunkState->OsDescriptorMapping.uiSSDescriptorMapping, (unsigned int)PhysicalAddress.QuadPart);
    }
    return  NtStatus;

}

/**********************************************************************
 * 
 *  Mutiny_MapLinearAddresses
 *
 *    This API will setup 32 bit  page tables for linear addressing
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapLinearAddresses(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    unsigned int uiIndex = 0;

    DbgPrint("**************** Mapping Linear Addresses for 32 bit **************************\n");


    uiIndex = 0;
    while(g_pMapPageTablesAsLinearAddress[uiIndex] != NULL)
    {
        PhysicalAddress = MmGetPhysicalAddress(g_pMapPageTablesAsLinearAddress[uiIndex]);
        if(PhysicalAddress.QuadPart)
        {
            Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)g_pMapPageTablesAsLinearAddress[uiIndex], (unsigned int)PhysicalAddress.QuadPart);
            DbgPrint("Mapped Linear Virtual Address %0x to (Physical %0x)\n\n", g_pMapPageTablesAsLinearAddress[uiIndex],  (unsigned int)PhysicalAddress.QuadPart);
        }
        uiIndex++;
    }
    
    uiIndex = 0;

  /*  for(uiIndex = 0; uiIndex < 800*600*4; uiIndex+=4096)*/
    { 
       Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)0xA0000 + uiIndex, (unsigned int)0xA0000 + uiIndex);
    }

    Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, 0, (unsigned int)0xB8000, (unsigned int)0xB8000);

    return  NtStatus;
}



/**********************************************************************
 * 
 *  Mutiny_MapIdentityCodeSegments
 *
 *    This API will setup 32 bit Identity page tables for code
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapIdentityCodeSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    int uiIdentityOffset = 0, uiIdentityDescriptorOffset = 0;
    unsigned int uiIndex = 0, uiIdentityDescriptor;

    uiIndex = 0;
    DbgPrint("**************** Mapping Identity Code Segments for 32 bit **************************\n");

    while(g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex] != NULL)
    {
        PhysicalAddress = MmGetPhysicalAddress(g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex]);

        if(PhysicalAddress.QuadPart)
        {
            uiIdentityDescriptorOffset = 0;/*((int)PhysicalAddress.QuadPart) - ((int)g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex]);*/
            uiIdentityOffset = (unsigned int)(PhysicalAddress.QuadPart); 

            uiIdentityDescriptor = GDT_CreateCodeIdentityDescriptor(pOperatingSystemThunkState, 0);
            
            if(uiIndex == 1)
            {
                pOperatingSystemThunkState->OsDescriptorMapping.uiIdentityCSDescriptorMapping = uiIdentityDescriptor;
                pOperatingSystemThunkState->OsDescriptorMapping.uiCodePhysicalAddress         = (unsigned int)(((unsigned int)PhysicalAddress.QuadPart)&0xFFFFFF000);
            }

            Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)uiIdentityOffset, (unsigned int)PhysicalAddress.QuadPart);
            DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Virtual %0x, Physical %0x)\n\n", g_pMapPageTablesToCodeSegmentAsIdentity[uiIndex],  uiIdentityDescriptor, uiIdentityDescriptorOffset, uiIdentityOffset, (unsigned int)PhysicalAddress.QuadPart);
        }

        uiIndex++;                                                       
    }

    return  NtStatus;
}


/**********************************************************************
 * 
 *  Mutiny_MapIdentityStackSegments
 *
 *    This API will setup 32 bit Identity page tables for stack
 * 
 *
 **********************************************************************/
NTSTATUS Mutiny_MapIdentityStackSegments(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress;
    int uiIdentityOffset = 0, uiIdentityDescriptorOffset = 0;
    unsigned int uiIndex = 0, uiIdentityDescriptor;

    DbgPrint("**************** Mapping Identity Stack Segments for 32 bit **************************\n");


    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState);
    
    if(PhysicalAddress.QuadPart)
    {
        uiIdentityDescriptorOffset = ((int)PhysicalAddress.QuadPart) - ((int)pOperatingSystemThunkState);
        uiIdentityDescriptor = GDT_CreateDataIdentityDescriptor(pOperatingSystemThunkState, uiIdentityDescriptorOffset);
        
        pOperatingSystemThunkState->OsDescriptorMapping.uiIdentitySSDescriptorMapping  = uiIdentityDescriptor;

        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState,  uiIdentityDescriptor, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart);
    }

    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState + 4096);
    
    if(PhysicalAddress.QuadPart)
    {
        uiIdentityDescriptorOffset = ((int)PhysicalAddress.QuadPart) - ((int)pOperatingSystemThunkState + 4096);
        uiIdentityDescriptor = GDT_CreateCodeIdentityDescriptor(pOperatingSystemThunkState, uiIdentityDescriptorOffset);

        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState + 4096,  uiIdentityDescriptor, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart);
    }    
    
    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState - 4096);

    if(PhysicalAddress.QuadPart)
    {
        uiIdentityDescriptorOffset = ((int)PhysicalAddress.QuadPart) - ((int)pOperatingSystemThunkState - 4096);
        uiIdentityDescriptor = GDT_CreateDataIdentityDescriptor(pOperatingSystemThunkState, uiIdentityDescriptorOffset);
        
        pOperatingSystemThunkState->OsDescriptorMapping.uiIdentitySSDescriptorMapping  = uiIdentityDescriptor;

        Paging32_MapVirtualToPhysical(pOperatingSystemThunkState, uiIdentityDescriptorOffset, (unsigned int)pOperatingSystemThunkState, (unsigned int)PhysicalAddress.QuadPart);
        DbgPrint("Mapped Identity Virtual Address %0x to (Selector %0x, Selector Base %0x, Physical %0x)\n\n", pOperatingSystemThunkState - 4096,  uiIdentityDescriptor, uiIdentityDescriptorOffset, (unsigned int)PhysicalAddress.QuadPart);
    }

    return  NtStatus;
}

/**********************************************************************
 * 
 *  Mutiny_OperatingSystemFreeResources
 *
 *    This API will free the data that was required to thunk the
 *    operating system.
 *
 **********************************************************************/
NTSTATUS Mutiny_OperatingSystemFreeResources(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;

    GDT_Free64BitGlobalDescriptorTable(pOperatingSystemThunkState);
    IDT_Free64BitInterruptDescriptorTable(pOperatingSystemThunkState);
    
    /*
     * Destroy the Page Tables
     *
     */
    if((pOperatingSystemThunkState->OsState32.uiCR4 & 0x20) == 0)
    {
        Paging32_DestroyPageTables(pOperatingSystemThunkState);
    }
    
    PhysicalAddressExtensions32_DestroyPageTables(pOperatingSystemThunkState);
    Memory_FreeNonPaged4kAligned(&pOperatingSystemThunkState->Application64.OSAllocatedMemoryBlock);

    return NtStatus;
}


/**********************************************************************
 * 
 *  Mutiny_SaveState
 *
 *    This API will save the current OS State
 *
 **********************************************************************/
__declspec (naked)  void Mutiny_SaveState(PSAVE_OS_STATE32 pOsState32)
{
    _asm {
           PUSH EBP
           MOV EBP, ESP
           PUSH ESI
           MOV ESI, [EBP + 8] 
           
           MOV EAX, CR0                     ; Save CR0 State
           MOV [ESI], EAX
           
           ADD ESI, 4
           
           MOV EAX, CR3                     ; Save CR3 State
           MOV [ESI], EAX

           ADD ESI, 4

           ; MOV EAX, CR4                     ; Save CR4 State
           ;                                   The compiler does not recognize CR4. 
           __emit 0fh
           __emit 20h
           __emit 0e0h
           
           MOV [ESI], EAX
            
           ADD ESI, 4
            
           MOV AX, CS
           MOV [ESI], AX                      ; Save CS
           
           ADD ESI, 2
           
           MOV AX, DS                         ; Save DS
           MOV [ESI], AX
           
           ADD ESI, 2
           
           MOV AX, ES                         ; Save ES
           MOV [ESI], AX
           
           ADD ESI, 2
           
           MOV AX, FS                         ; Save FS
           MOV [ESI], AX
           
           ADD ESI, 2

           MOV AX, GS                         ; Save GS
           MOV [ESI], AX
           
           ADD ESI, 2

           MOV AX, SS                         ; Save SS
           MOV [ESI], AX
           
           ADD ESI, 2
           
           
           SGDT [ESI]                        ; Save Global Descriptor Table
           
           ADD ESI, 6
             
           SLDT [ESI]                       ; Save Local Descriptor Table
           
           ADD ESI, 6

           SIDT [ESI]                       ; Save Interrupt Descriptor Table
           
           POP ESI
           POP EBP
           
           RET 4
    }

}

/**********************************************************************
 * 
 *  Mutiny_RestoreState
 *
 *    This API will restore the current OS State
 *       This API is for testing purposes.
 *
 **********************************************************************/
__declspec (naked)  void Mutiny_RestoreState(PSAVE_OS_STATE32 pOsState32)
{
    _asm {
           PUSH EBP
           MOV EBP, ESP
           PUSH ESI
           MOV ESI, [EBP + 8] 
           
           MOV EAX, [ESI]                     ; Restore CR0 State
           MOV CR0, EAX
           
           ADD ESI, 4
           
           MOV EAX, [ESI]                     ; Restore CR3 State
           MOV CR3, EAX

           ADD ESI, 4

           MOV EAX, [ESI]                     ; Restore CR4 State
           
           ; MOV CR4, EAX  The compiler does not recognize CR4. 
           __emit 0fh
           __emit 22h
           __emit 0e0h
            
           ADD ESI, 4 + 2 + 2 + 2 + 2 + 2 + 2 ; We have already restored CS
                                              ; and we never modify DS or SS
           
           LGDT [ESI]                         ; Restore Global Descriptor Table
           
           ADD ESI, 6
             
           LLDT [ESI]                         ; Restore Local Descriptor Table
           
           ADD ESI, 6

           LIDT [ESI]                         ; Restore Interrupt Descriptor Table
           
           POP ESI
           POP EBP
           
           RET 4
    }       
}









