/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Driver!
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/




#ifndef __MEMORY_H__
#define __MEMORY_H__

typedef struct _MEMORY_BLOCK
{
    PVOID pAllocatedVirtualMemory;
    unsigned int uiVirtualBlockSize;
    unsigned int PhysicalAddress;

    PVOID pVirtualMappingOf4kPhysicalAddress;
    unsigned int Aligned4kPhysicalAddress;
    unsigned int uiPageAlignedBlockSize;

} MEMORY_BLOCK, *PMEMORY_BLOCK;

void Memory_FreeNonPaged4kAligned(PMEMORY_BLOCK pMemoryBlock);
NTSTATUS Memory_AllocateNonPaged4kPhysicallyAligned(UINT32 uiNumberOfPages, PMEMORY_BLOCK pMemoryBlock);



#endif






