/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Driver!
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/




#ifndef __IDT_H__
#define __IDT_H__


    
struct _OPERATING_SYSTEM_THUNK_DATA;
typedef struct _OPERATING_SYSTEM_THUNK_DATA *POPERATING_SYSTEM_THUNK_DATA;


/**********************************************************
 * Descriptor Entry Constants
 *
 *   The following describe the contants used to set
 *   data on the bit entries in the IDT descriptor entries
 *
 *   Brief descriptions are included however for more information
 *   simply consult the INTEL and AMD processor reference manuals.
 **********************************************************/
 
 /*
  * Descriptor Privlege Level
  *    
  *    0 = Most Privledge, 3 = Least Privledge
  */
#define  IDT_DPL_0     0x0000
#define  IDT_DPL_1     0x2000
#define  IDT_DPL_2     0x4000
#define  IDT_DPL_3     0x6000
#define  IDT_DPL_MASK  0x9FFF

 /*
  * System Bit
  *
  *  This helps to define the type of descriptor.
  *    
  *    1 = User
  *        Types = Code, Data
  *
  *    0 = System
  *        Types = LDT, TSS, Call gate
  *     
  */
#define  IDT_SYSTEM_BIT      0x1000
#define  IDT_SYSTEM_BIT_MASK 0xEFFF

/*
 * Present Bit
 *
 *   Informs the CPU that this segment is loaded into memory.
 *   If this bit is not set then an exception occurs.
 *
 */ 
 
#define  IDT_PRESENT_BIT       0x8000
#define  IDT_PRESENT_BIT_MASK  0x7FFF

    
/* Interrupt Stack Table (IST)
 *
 *   0 = Modified Legacy Implementation
 *   NonZero = Index into TSS To get an IST Pointer into RSP.
 *
 *   This defines the behavior of how to switch the stack
 *   when an interrupt occurs.
 */
#define  IDT_IST_0     0x0000
#define  IDT_IST_1     0x0001
#define  IDT_IST_2     0x0002
#define  IDT_IST_3     0x0003
#define  IDT_IST_MASK  0xFFFC



/* Type Field
 *
 *   Defines Code, Data, System or Gate
 *
 */
#define  IDT_CODE_DESCRIPTOR            0x1800
#define  IDT_DATA_DESCRIPTOR            0x1000
#define  IDT_CODE_DATA_DESCRIPTOR_MASK  0xE7FF

#define  IDT_TYPE_MASK                  0xF0FF



/**********************************************************
 * IDT Gate Descriptor Entry
 *
 *     The Following is the Interrupt Gate Descriptor for 64 bit
 *
 *   --------------------------------------------------------
 *   \                   Reserved                           \ + 12
 *   +------------------------------------------------------+
 *   \              Target Offset 63 - 32                   \ + 8
 *   +-----------------------+------------------------------+
 *   \ Target Offset 31-16   \ P \ DPL \S \ Type \ Res.\ IST\ + 4
 *   +-----------------------+------------------------------+
 *   \ Target Selector       \  Target Offset 15 - 0        \ + 0
 *   +-----------------------+------------------------------+
 *
 *  Descriptions
 *   Target Offset    =
 *   Target Selector  =
 *   P                =
 *   DPL              =
 *   S                =
 *   Type             =
 *   Res.             = Short for "Reserved"
 *   IST              =
 *
 **********************************************************/
#pragma pack(1)
typedef struct _IDT_GATE_DESCRIPTOR_ENTRY
{
    unsigned short   wTargetOffsetLow;
    unsigned short   wTargetSelector;
    unsigned short   wFlags;
    unsigned short   wTargetOffsetMiddle;
    unsigned int     uiTargetOffsetHigh;
    unsigned int     uiReserved;

} IDT_GATE_DESCRIPTOR_ENTRY, *PIDT_GATE_DESCRIPTOR_ENTRY;


NTSTATUS IDT_Free64BitInterruptDescriptorTable(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS IDT_Setup64BitInterruptDescriptorTable(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);

#endif






